/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.callbacks.LoggingCallback;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.commandhandling.gateway.RetryingCallback;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;

public abstract class AbstractCommandGateway {
    private final CommandBus commandBus;
    private final RetryScheduler retryScheduler;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;

    protected AbstractCommandGateway(Builder builder) {
        builder.validate();
        this.commandBus = builder.commandBus;
        this.retryScheduler = builder.retryScheduler;
        this.dispatchInterceptors = builder.dispatchInterceptors;
    }

    protected <C, R> void send(@Nonnull C command, @Nonnull CommandCallback<? super C, ? super R> callback) {
        CommandMessage commandMessage = this.processInterceptors(GenericCommandMessage.asCommandMessage(command));
        CommandCallback<? super C, ? super R> commandCallback = callback;
        if (this.retryScheduler != null) {
            commandCallback = new RetryingCallback<C, R>(callback, this.retryScheduler, this.commandBus);
        }
        this.commandBus.dispatch(commandMessage, commandCallback);
    }

    protected void sendAndForget(Object command) {
        if (this.retryScheduler == null) {
            this.commandBus.dispatch(this.processInterceptors(GenericCommandMessage.asCommandMessage(command)));
        } else {
            CommandMessage commandMessage = GenericCommandMessage.asCommandMessage(command);
            this.send(commandMessage, LoggingCallback.INSTANCE);
        }
    }

    protected Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super CommandMessage<?>> interceptor) {
        this.dispatchInterceptors.add(interceptor);
        return () -> this.dispatchInterceptors.remove(interceptor);
    }

    protected <C> CommandMessage<? extends C> processInterceptors(CommandMessage<C> commandMessage) {
        CommandMessage<C> message = commandMessage;
        for (MessageDispatchInterceptor<CommandMessage<?>> dispatchInterceptor : this.dispatchInterceptors) {
            message = dispatchInterceptor.handle(message);
        }
        return message;
    }

    public CommandBus getCommandBus() {
        return this.commandBus;
    }

    public static abstract class Builder {
        private CommandBus commandBus;
        private RetryScheduler retryScheduler;
        private List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();

        public Builder commandBus(@Nonnull CommandBus commandBus) {
            BuilderUtils.assertNonNull(commandBus, "CommandBus may not be null");
            this.commandBus = commandBus;
            return this;
        }

        public Builder retryScheduler(@Nonnull RetryScheduler retryScheduler) {
            this.retryScheduler = retryScheduler;
            return this;
        }

        public Builder dispatchInterceptors(MessageDispatchInterceptor<? super CommandMessage<?>> ... dispatchInterceptors) {
            return this.dispatchInterceptors(Arrays.asList(dispatchInterceptors));
        }

        public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
            this.dispatchInterceptors = dispatchInterceptors != null && !dispatchInterceptors.isEmpty() ? new CopyOnWriteArrayList(dispatchInterceptors) : new CopyOnWriteArrayList();
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.commandBus, "The CommandBus is a hard requirement and should be provided");
        }
    }
}

