/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Arrays;
import java.util.Objects;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public abstract class DispatchMessage {
    protected String commandIdentifier;
    protected byte[] serializedMetaData;
    protected String payloadType;
    protected String payloadRevision;
    protected byte[] serializedPayload;
    protected String commandName;
    protected boolean expectReply;

    protected DispatchMessage() {
    }

    protected DispatchMessage(CommandMessage<?> commandMessage, Serializer serializer, boolean expectReply) {
        this.commandIdentifier = commandMessage.getIdentifier();
        SerializedObject<byte[]> metaData = commandMessage.serializeMetaData(serializer, byte[].class);
        this.serializedMetaData = metaData.getData();
        SerializedObject<byte[]> payload = commandMessage.serializePayload(serializer, byte[].class);
        this.payloadType = payload.getType().getName();
        this.payloadRevision = payload.getType().getRevision();
        this.serializedPayload = payload.getData();
        this.commandName = commandMessage.getCommandName();
        this.expectReply = expectReply;
    }

    public CommandMessage<?> getCommandMessage(Serializer serializer) {
        SimpleSerializedObject<byte[]> serializedPayload = new SimpleSerializedObject<byte[]>(this.serializedPayload, byte[].class, this.payloadType, this.payloadRevision);
        Object payload = serializer.deserialize(serializedPayload);
        SerializedMetaData<byte[]> serializedMetaData = new SerializedMetaData<byte[]>(this.serializedMetaData, byte[].class);
        MetaData metaData = (MetaData)serializer.deserialize(serializedMetaData);
        return new GenericCommandMessage(new GenericMessage(this.commandIdentifier, payload, metaData), this.commandName);
    }

    public String getCommandIdentifier() {
        return this.commandIdentifier;
    }

    public byte[] getSerializedMetaData() {
        return this.serializedMetaData;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public String getPayloadRevision() {
        return this.payloadRevision;
    }

    public byte[] getSerializedPayload() {
        return this.serializedPayload;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public boolean isExpectReply() {
        return this.expectReply;
    }

    public int hashCode() {
        return Objects.hash(this.commandIdentifier, this.serializedMetaData, this.payloadType, this.payloadRevision, this.serializedPayload, this.commandName, this.expectReply);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DispatchMessage other = (DispatchMessage)obj;
        return Objects.equals(this.commandIdentifier, other.commandIdentifier) && Objects.deepEquals(this.serializedMetaData, other.serializedMetaData) && Objects.equals(this.payloadType, other.payloadType) && Objects.equals(this.payloadRevision, other.payloadRevision) && Objects.deepEquals(this.serializedPayload, other.serializedPayload) && Objects.equals(this.commandName, other.commandName) && Objects.equals(this.expectReply, other.expectReply);
    }

    public String toString() {
        return "DispatchMessage{commandIdentifier='" + this.commandIdentifier + '\'' + ", serializedMetaData=" + Arrays.toString(this.serializedMetaData) + ", payloadType='" + this.payloadType + '\'' + ", payloadRevision='" + this.payloadRevision + '\'' + ", serializedPayload=" + Arrays.toString(this.serializedPayload) + ", commandName='" + this.commandName + '\'' + ", expectReply=" + this.expectReply + '}';
    }
}

