/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.messaging.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDuplicateCommandHandlerResolver
implements DuplicateCommandHandlerResolver {
    private static final Logger logger = LoggerFactory.getLogger(LoggingDuplicateCommandHandlerResolver.class);
    private static final LoggingDuplicateCommandHandlerResolver INSTANCE = new LoggingDuplicateCommandHandlerResolver();

    public static LoggingDuplicateCommandHandlerResolver instance() {
        return INSTANCE;
    }

    private LoggingDuplicateCommandHandlerResolver() {
    }

    @Override
    public MessageHandler<? super CommandMessage<?>> resolve(@Nonnull String commandName, @Nonnull MessageHandler<? super CommandMessage<?>> registeredHandler, @Nonnull MessageHandler<? super CommandMessage<?>> candidateHandler) {
        logger.warn("A duplicate command handler was found for command [{}]. The handler in [{}] has been replaced by the handler in [{}].", new Object[]{commandName, registeredHandler.getTargetType().getName(), candidateHandler.getTargetType().getName()});
        return candidateHandler;
    }
}

