/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.axonframework.queryhandling.SinkWrapper;
import reactor.core.publisher.Sinks;

class SinksManyWrapper<T>
implements SinkWrapper<T> {
    private final Sinks.Many<T> fluxSink;

    SinksManyWrapper(Sinks.Many<T> fluxSink) {
        this.fluxSink = fluxSink;
    }

    @Override
    public void complete() {
        this.performWithBusyWaitSpin(() -> this.fluxSink.tryEmitComplete()).orThrow();
    }

    @Override
    public void next(T value) {
        this.performWithBusyWaitSpin(() -> this.fluxSink.tryEmitNext(value)).orThrow();
    }

    @Override
    public void error(Throwable t) {
        this.performWithBusyWaitSpin(() -> this.fluxSink.tryEmitError(t)).orThrow();
    }

    private Sinks.EmitResult performWithBusyWaitSpin(Supplier<Sinks.EmitResult> action) {
        Sinks.EmitResult result;
        int i = 0;
        while ((result = action.get()) == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
            if (i < 100) {
                ++i;
                continue;
            }
            if (i < 200) {
                ++i;
                Thread.yield();
                continue;
            }
            LockSupport.parkNanos(100L);
        }
        return result;
    }
}

