/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jdbc;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventhandling.tokenstore.GenericTokenEntry;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenSchema;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenTableFactory;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTokenStore.class);
    private final ConnectionProvider connectionProvider;
    private final Serializer serializer;
    private final TokenSchema schema;
    private final TemporalAmount claimTimeout;
    private final String nodeId;
    private final Class<?> contentType;

    public static Builder builder() {
        return new Builder();
    }

    protected JdbcTokenStore(Builder builder) {
        builder.validate();
        this.connectionProvider = builder.connectionProvider;
        this.serializer = builder.serializer;
        this.schema = builder.schema;
        this.claimTimeout = builder.claimTimeout;
        this.nodeId = builder.nodeId;
        this.contentType = builder.contentType;
    }

    public void createSchema(TokenTableFactory schemaFactory) {
        Connection c = this.getConnection();
        try {
            JdbcUtils.executeUpdates(c, e -> {
                throw new JdbcException("Failed to create token tables", (Throwable)e);
            }, connection -> schemaFactory.createTable(connection, this.schema));
        }
        finally {
            JdbcUtils.closeQuietly(c);
        }
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, 0), resultSet -> {
                for (int segment = 0; segment < segmentCount; ++segment) {
                    this.insertTokenEntry(resultSet, initialToken, processorName, segment);
                }
                return null;
            }, e -> new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.", (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSegment(TrackingToken token, String processorName, int segment) throws UnableToInitializeTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, 0), resultSet -> {
                this.insertTokenEntry(resultSet, token, processorName, segment);
                return null;
            }, e -> new UnableToInitializeTokenException("Could not initialize segments. Some segments were already present.", (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    @Override
    public boolean requiresExplicitSegmentInitialization() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, segment), resultSet -> {
                this.updateToken(resultSet, token, processorName, segment);
                return null;
            }, e -> new JdbcException(String.format("Could not store token [%s] for processor [%s] and segment [%d]", token, processorName, segment), (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackingToken fetchToken(String processorName, int segment) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            TrackingToken trackingToken = JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, segment), resultSet -> this.loadToken(resultSet, processorName, segment), e -> new JdbcException(String.format("Could not load token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e));
            return trackingToken;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseClaim(String processorName, int segment) {
        Connection connection = this.getConnection();
        try {
            int[] result = JdbcUtils.executeUpdates(connection, e -> {
                throw new JdbcException(String.format("Could not load token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e);
            }, c -> this.releaseClaim(c, processorName, segment));
            if (result[0] < 1) {
                logger.warn("Releasing claim of token {}/{} failed. It was owned by another node.", (Object)processorName, (Object)segment);
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteToken(String processorName, int segment) {
        Connection connection = this.getConnection();
        try {
            int[] result = JdbcUtils.executeUpdates(connection, e -> {
                throw new JdbcException(String.format("Could not remove token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e);
            }, c -> this.deleteToken(c, processorName, segment));
            if (result[0] < 1) {
                throw new UnableToClaimTokenException("Unable to claim token. It wasn't owned by " + this.nodeId);
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] fetchSegments(String processorName) {
        Connection connection = this.getConnection();
        try {
            List<Integer> integers = JdbcUtils.executeQuery(connection, c -> this.selectForSegments(c, processorName), JdbcUtils.listResults(rs -> rs.getInt(this.schema.segmentColumn())), e -> new JdbcException(String.format("Could not load segments for processor [%s]", processorName), (Throwable)e));
            int[] nArray = integers.stream().mapToInt(i -> i).toArray();
            return nArray;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    protected PreparedStatement selectForSegments(Connection connection, String processorName) throws SQLException {
        String sql = "SELECT " + this.schema.segmentColumn() + " FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? ORDER BY " + this.schema.segmentColumn() + " ASC";
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1003, 1007);
        preparedStatement.setString(1, processorName);
        return preparedStatement;
    }

    protected PreparedStatement selectForUpdate(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "SELECT " + String.join((CharSequence)", ", this.schema.processorNameColumn(), this.schema.segmentColumn(), this.schema.tokenColumn(), this.schema.tokenTypeColumn(), this.schema.timestampColumn(), this.schema.ownerColum()) + " FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? FOR UPDATE";
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1003, 1008);
        preparedStatement.setString(1, processorName);
        preparedStatement.setInt(2, segment);
        return preparedStatement;
    }

    protected void updateToken(ResultSet resultSet, TrackingToken token, String processorName, int segment) throws SQLException {
        if (!resultSet.next()) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has not been initialized yet", processorName, segment));
        }
        AbstractTokenEntry<?> entry = this.readTokenEntry(resultSet);
        entry.updateToken(token, this.serializer);
        resultSet.updateObject(this.schema.tokenColumn(), entry.getSerializedToken().getData());
        resultSet.updateString(this.schema.tokenTypeColumn(), entry.getSerializedToken().getType().getName());
        resultSet.updateString(this.schema.timestampColumn(), entry.timestampAsString());
        this.claimToken(resultSet, entry);
    }

    protected TrackingToken claimToken(ResultSet resultSet, AbstractTokenEntry<?> entry) throws SQLException {
        if (!entry.claim(this.nodeId, this.claimTimeout)) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", entry.getProcessorName(), entry.getSegment(), entry.getOwner()));
        }
        resultSet.updateString(this.schema.ownerColum(), entry.getOwner());
        resultSet.updateString(this.schema.timestampColumn(), entry.timestampAsString());
        resultSet.updateRow();
        return entry.getToken(this.serializer);
    }

    protected TrackingToken loadToken(ResultSet resultSet, String processorName, int segment) throws SQLException {
        if (!resultSet.next()) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has not been initialized yet", processorName, segment));
        }
        return this.claimToken(resultSet, this.readTokenEntry(resultSet));
    }

    protected TrackingToken insertTokenEntry(ResultSet resultSet, TrackingToken token, String processorName, int segment) throws SQLException {
        GenericTokenEntry entry = new GenericTokenEntry(token, this.serializer, this.contentType, processorName, segment);
        resultSet.moveToInsertRow();
        resultSet.updateObject(this.schema.tokenColumn(), token == null ? null : entry.getSerializedToken().getData());
        resultSet.updateString(this.schema.tokenTypeColumn(), token == null ? null : entry.getSerializedToken().getType().getName());
        resultSet.updateString(this.schema.timestampColumn(), entry.timestampAsString());
        resultSet.updateString(this.schema.ownerColum(), entry.getOwner());
        resultSet.updateString(this.schema.processorNameColumn(), processorName);
        resultSet.updateInt(this.schema.segmentColumn(), segment);
        resultSet.insertRow();
        return token;
    }

    protected AbstractTokenEntry<?> readTokenEntry(ResultSet resultSet) throws SQLException {
        return new GenericTokenEntry(this.readSerializedData(resultSet, this.schema.tokenColumn()), resultSet.getString(this.schema.tokenTypeColumn()), resultSet.getString(this.schema.timestampColumn()), resultSet.getString(this.schema.ownerColum()), resultSet.getString(this.schema.processorNameColumn()), resultSet.getInt(this.schema.segmentColumn()), this.contentType);
    }

    protected PreparedStatement releaseClaim(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "UPDATE " + this.schema.tokenTable() + " SET " + this.schema.ownerColum() + " = ?, " + this.schema.timestampColumn() + " = ? WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? AND " + this.schema.ownerColum() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, DateTimeUtils.formatInstant(AbstractTokenEntry.clock.instant()));
        preparedStatement.setString(3, processorName);
        preparedStatement.setInt(4, segment);
        preparedStatement.setString(5, this.nodeId);
        return preparedStatement;
    }

    protected PreparedStatement deleteToken(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "DELETE FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? AND " + this.schema.ownerColum() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, processorName);
        preparedStatement.setInt(2, segment);
        preparedStatement.setString(3, this.nodeId);
        return preparedStatement;
    }

    protected <T> T readSerializedData(ResultSet resultSet, String columnName) throws SQLException {
        if (byte[].class.equals(this.contentType)) {
            return (T)resultSet.getBytes(columnName);
        }
        return (T)resultSet.getObject(columnName);
    }

    protected Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new JdbcException("Failed to obtain a database connection", e);
        }
    }

    public static class Builder {
        private ConnectionProvider connectionProvider;
        private Serializer serializer;
        private TokenSchema schema = new TokenSchema();
        private TemporalAmount claimTimeout = Duration.ofSeconds(10L);
        private String nodeId = ManagementFactory.getRuntimeMXBean().getName();
        private Class<?> contentType = byte[].class;

        public Builder connectionProvider(ConnectionProvider connectionProvider) {
            BuilderUtils.assertNonNull(connectionProvider, "ConnectionProvider may not be null");
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder schema(TokenSchema schema) {
            BuilderUtils.assertNonNull(schema, "TokenSchema may not be null");
            this.schema = schema;
            return this;
        }

        public Builder claimTimeout(TemporalAmount claimTimeout) {
            BuilderUtils.assertNonNull(claimTimeout, "The claim timeout may not be null");
            this.claimTimeout = claimTimeout;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.assertNodeId(nodeId, "The nodeId may not be null or empty");
            this.nodeId = nodeId;
            return this;
        }

        public Builder contentType(Class<?> contentType) {
            BuilderUtils.assertNonNull(contentType, "The content type may not be null");
            this.contentType = contentType;
            return this;
        }

        public JdbcTokenStore build() {
            return new JdbcTokenStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.connectionProvider, "The ConnectionProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided");
            this.assertNodeId(this.nodeId, "The nodeId is a hard requirement and should be provided");
        }

        private void assertNodeId(String nodeId, String exceptionMessage) {
            BuilderUtils.assertThat(nodeId, name -> Objects.nonNull(name) && !"".equals(name), exceptionMessage);
        }
    }
}

