/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class SimpleEventHandlerInvoker
implements EventHandlerInvoker {
    private final List<?> eventHandlers;
    private final List<EventMessageHandler> wrappedEventHandlers;
    private final ListenerInvocationErrorHandler listenerInvocationErrorHandler;
    private final SequencingPolicy<? super EventMessage<?>> sequencingPolicy;

    protected SimpleEventHandlerInvoker(Builder builder) {
        builder.validate();
        this.eventHandlers = builder.eventHandlers;
        this.wrappedEventHandlers = this.eventHandlers.stream().map(handler -> handler instanceof EventMessageHandler ? (EventMessageHandler)handler : builder.wrapEventMessageHandler(handler)).collect(Collectors.toCollection(ArrayList::new));
        this.sequencingPolicy = builder.sequencingPolicy;
        this.listenerInvocationErrorHandler = builder.listenerInvocationErrorHandler;
    }

    private static List<?> detectList(Object[] eventHandlers) {
        return eventHandlers.length == 1 && eventHandlers[0] instanceof List ? (List)eventHandlers[0] : Arrays.asList(eventHandlers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<?> eventHandlers() {
        return Collections.unmodifiableList(this.eventHandlers);
    }

    @Override
    public void handle(EventMessage<?> message, Segment segment) throws Exception {
        if (this.sequencingPolicyMatchesSegment(message, segment)) {
            for (EventMessageHandler handler : this.wrappedEventHandlers) {
                try {
                    handler.handle(message);
                }
                catch (Exception e) {
                    this.listenerInvocationErrorHandler.onError(e, message, handler);
                }
            }
        }
    }

    @Override
    public boolean canHandle(EventMessage<?> eventMessage, Segment segment) {
        return this.hasHandler(eventMessage) && this.sequencingPolicyMatchesSegment(eventMessage, segment);
    }

    private boolean hasHandler(EventMessage<?> eventMessage) {
        for (EventMessageHandler eventHandler : this.wrappedEventHandlers) {
            if (!eventHandler.canHandle(eventMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsReset() {
        for (EventMessageHandler eventHandler : this.wrappedEventHandlers) {
            if (eventHandler.supportsReset()) continue;
            return false;
        }
        return true;
    }

    private boolean sequencingPolicyMatchesSegment(EventMessage<?> message, Segment segment) {
        return segment.matches(Objects.hashCode(ObjectUtils.getOrDefault(this.sequencingPolicy.getSequenceIdentifierFor(message), message::getIdentifier)));
    }

    @Override
    public void performReset() {
        for (EventMessageHandler eventHandler : this.wrappedEventHandlers) {
            eventHandler.prepareReset();
        }
    }

    public ListenerInvocationErrorHandler getListenerInvocationErrorHandler() {
        return this.listenerInvocationErrorHandler;
    }

    public SequencingPolicy<? super EventMessage<?>> getSequencingPolicy() {
        return this.sequencingPolicy;
    }

    public static class Builder {
        private List<?> eventHandlers;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private ListenerInvocationErrorHandler listenerInvocationErrorHandler = new LoggingErrorHandler();
        private SequencingPolicy<? super EventMessage<?>> sequencingPolicy = SequentialPerAggregatePolicy.instance();

        public Builder eventHandlers(Object ... eventHandlers) {
            return this.eventHandlers(SimpleEventHandlerInvoker.detectList(eventHandlers));
        }

        public Builder eventHandlers(List<?> eventHandlers) {
            BuilderUtils.assertThat(eventHandlers, list -> !list.isEmpty(), "At least one EventMessageHandler should be provided");
            this.eventHandlers = eventHandlers;
            return this;
        }

        public Builder parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull(parameterResolverFactory, "ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull(handlerDefinition, "HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder listenerInvocationErrorHandler(ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
            BuilderUtils.assertNonNull(listenerInvocationErrorHandler, "ListenerInvocationErrorHandler may not be null");
            this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
            return this;
        }

        public Builder sequencingPolicy(SequencingPolicy<? super EventMessage<?>> sequencingPolicy) {
            BuilderUtils.assertNonNull(sequencingPolicy, "{} may not be null");
            this.sequencingPolicy = sequencingPolicy;
            return this;
        }

        public SimpleEventHandlerInvoker build() {
            return new SimpleEventHandlerInvoker(this);
        }

        public AnnotationEventHandlerAdapter wrapEventMessageHandler(Object eventHandler) {
            if (this.parameterResolverFactory == null && this.handlerDefinition == null) {
                return new AnnotationEventHandlerAdapter(eventHandler);
            }
            if (this.parameterResolverFactory != null && this.handlerDefinition == null) {
                return new AnnotationEventHandlerAdapter(eventHandler, this.parameterResolverFactory);
            }
            return new AnnotationEventHandlerAdapter(eventHandler, this.parameterResolverFactory, this.handlerDefinition);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertThat(this.eventHandlers, list -> list != null && !list.isEmpty(), "At least one EventMessageHandler should be provided");
        }
    }
}

