/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.RemoteExceptionDescription;
import org.axonframework.messaging.RemoteHandlingException;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public abstract class ReplyMessage
implements Serializable {
    protected String commandIdentifier;
    protected byte[] serializedMetaData;
    protected String payloadType;
    protected String payloadRevision;
    protected byte[] serializedPayload;
    protected String exceptionType;
    protected String exceptionRevision;
    protected byte[] serializedException;

    protected ReplyMessage() {
    }

    public ReplyMessage(String commandIdentifier, CommandResultMessage<?> commandResultMessage, Serializer serializer) {
        this.commandIdentifier = commandIdentifier;
        SerializedObject<byte[]> metaData = commandResultMessage.serializeMetaData(serializer, byte[].class);
        this.serializedMetaData = metaData.getData();
        SerializedObject<byte[]> payload = commandResultMessage.serializePayload(serializer, byte[].class);
        this.serializedPayload = payload.getData();
        this.payloadType = payload.getType().getName();
        this.payloadRevision = payload.getType().getRevision();
        SerializedObject<byte[]> exception = commandResultMessage.serializeExceptionResult(serializer, byte[].class);
        this.serializedException = exception.getData();
        this.exceptionType = exception.getType().getName();
        this.exceptionRevision = exception.getType().getRevision();
    }

    public CommandResultMessage<?> getCommandResultMessage(Serializer serializer) {
        Object payload = this.deserializePayload(serializer);
        RemoteExceptionDescription exceptionDescription = this.deserializeException(serializer);
        SerializedMetaData<byte[]> serializedMetaData = new SerializedMetaData<byte[]>(this.serializedMetaData, byte[].class);
        MetaData metaData = (MetaData)serializer.deserialize(serializedMetaData);
        if (exceptionDescription != null) {
            return new GenericCommandResultMessage(new RemoteHandlingException(exceptionDescription), (Map<String, ?>)metaData);
        }
        return new GenericCommandResultMessage<Object>(payload, metaData);
    }

    public String getCommandIdentifier() {
        return this.commandIdentifier;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public String getPayloadRevision() {
        return this.payloadRevision;
    }

    public byte[] getSerializedPayload() {
        return this.serializedPayload;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getExceptionRevision() {
        return this.exceptionRevision;
    }

    public byte[] getSerializedException() {
        return this.serializedException;
    }

    public byte[] getSerializedMetaData() {
        return this.serializedMetaData;
    }

    public int hashCode() {
        return Objects.hash(this.commandIdentifier, this.payloadType, this.payloadRevision, this.serializedPayload, this.exceptionType, this.exceptionRevision, this.serializedException, this.serializedMetaData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplyMessage other = (ReplyMessage)obj;
        return Objects.equals(this.commandIdentifier, other.commandIdentifier) && Objects.equals(this.payloadType, other.payloadType) && Objects.equals(this.payloadRevision, other.payloadRevision) && Objects.deepEquals(this.serializedPayload, other.serializedPayload) && Objects.deepEquals(this.exceptionType, other.exceptionType) && Objects.deepEquals(this.exceptionRevision, other.exceptionRevision) && Objects.deepEquals(this.serializedException, other.serializedException) && Objects.deepEquals(this.serializedMetaData, other.serializedMetaData);
    }

    public String toString() {
        return "ReplyMessage{commandIdentifier='" + this.commandIdentifier + '\'' + ", payloadType='" + this.payloadType + '\'' + ", payloadRevision='" + this.payloadRevision + '\'' + ", serializedPayload=" + Arrays.toString(this.serializedPayload) + ", exceptionType='" + this.exceptionType + '\'' + ", exceptionRevision='" + this.exceptionRevision + '\'' + ", serializedException='" + Arrays.toString(this.serializedMetaData) + ", serializedMetaData=" + Arrays.toString(this.serializedMetaData) + '}';
    }

    private Object deserializePayload(Serializer serializer) {
        return serializer.deserialize(new SimpleSerializedObject<byte[]>(this.serializedPayload, byte[].class, this.payloadType, this.payloadRevision));
    }

    private RemoteExceptionDescription deserializeException(Serializer serializer) {
        return (RemoteExceptionDescription)serializer.deserialize(new SimpleSerializedObject<byte[]>(this.serializedException, byte[].class, this.exceptionType, this.exceptionRevision));
    }
}

