/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;

public class CommandCallbackWrapper<A, C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<? super C, ? super R> wrapped;
    private final A sessionId;
    private final CommandMessage<C> message;

    public CommandCallbackWrapper(A channelId, CommandMessage<C> message, CommandCallback<? super C, ? super R> callback) {
        this.wrapped = callback;
        this.sessionId = channelId;
        this.message = message;
    }

    public CommandMessage<C> getMessage() {
        return this.message;
    }

    public A getChannelIdentifier() {
        return this.sessionId;
    }

    public void reportResult(CommandResultMessage<R> result) {
        this.onResult(this.getMessage(), result);
    }

    @Override
    public void onResult(CommandMessage<? extends C> message, CommandResultMessage<? extends R> commandResultMessage) {
        this.wrapped.onResult(message, commandResultMessage);
    }
}

