/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.Assert;
import org.axonframework.common.Priority;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

@Priority(value=0x7FFFFFFF)
public class InterceptorChainParameterResolverFactory
implements ParameterResolverFactory,
ParameterResolver<InterceptorChain> {
    private static final String INTERCEPTOR_CHAIN_EMITTER_KEY = InterceptorChain.class.getName();

    public static void initialize(InterceptorChain interceptorChain) {
        Assert.state(CurrentUnitOfWork.isStarted(), () -> "An active Unit of Work is required for injecting interceptor chain");
        CurrentUnitOfWork.get().resources().put(INTERCEPTOR_CHAIN_EMITTER_KEY, interceptorChain);
    }

    @Override
    public InterceptorChain resolveParameterValue(Message<?> message) {
        return CurrentUnitOfWork.map(uow -> (InterceptorChain)uow.getResource(INTERCEPTOR_CHAIN_EMITTER_KEY)).orElseThrow(() -> new IllegalStateException("InterceptorChain should have been injected"));
    }

    @Override
    public boolean matches(Message<?> message) {
        return message instanceof CommandMessage;
    }

    @Override
    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (InterceptorChain.class.equals(parameters[parameterIndex].getType())) {
            return this;
        }
        return null;
    }
}

