/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.interceptors.TransactionManagingInterceptor;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.queryhandling.DefaultSubscriptionQueryResult;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.MonoWrapper;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryExecutionException;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QuerySubscription;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.UpdateHandlerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryBus
implements QueryBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleQueryBus.class);
    private final ConcurrentMap<String, CopyOnWriteArrayList<QuerySubscription>> subscriptions = new ConcurrentHashMap<String, CopyOnWriteArrayList<QuerySubscription>>();
    private final MessageMonitor<? super QueryMessage<?, ?>> messageMonitor;
    private final QueryInvocationErrorHandler errorHandler;
    private final List<MessageHandlerInterceptor<? super QueryMessage<?, ?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private final List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final QueryUpdateEmitter queryUpdateEmitter;

    protected SimpleQueryBus(Builder builder) {
        builder.validate();
        this.messageMonitor = builder.messageMonitor;
        this.errorHandler = builder.errorHandler;
        if (builder.transactionManager != NoTransactionManager.INSTANCE) {
            this.registerHandlerInterceptor(new TransactionManagingInterceptor(builder.transactionManager));
        }
        this.queryUpdateEmitter = builder.queryUpdateEmitter;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <R> Registration subscribe(String queryName, Type responseType, MessageHandler<? super QueryMessage<?, R>> handler) {
        CopyOnWriteArrayList handlers = this.subscriptions.computeIfAbsent(queryName, k -> new CopyOnWriteArrayList());
        QuerySubscription querySubscription = new QuerySubscription(responseType, handler);
        handlers.addIfAbsent(querySubscription);
        return () -> this.unsubscribe(queryName, querySubscription);
    }

    private boolean unsubscribe(String queryName, QuerySubscription querySubscription) {
        this.subscriptions.computeIfPresent(queryName, (key, handlers) -> {
            handlers.remove(querySubscription);
            if (handlers.isEmpty()) {
                return null;
            }
            return handlers;
        });
        return true;
    }

    @Override
    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(QueryMessage<Q, R> query) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(query);
        QueryMessage<Q, R> interceptedQuery = this.intercept(query);
        List<MessageHandler<QueryMessage<?, ?>>> handlers = this.getHandlersForMessage(interceptedQuery);
        CompletableFuture result = new CompletableFuture();
        try {
            if (handlers.isEmpty()) {
                throw new NoHandlerForQueryException(String.format("No handler found for [%s] with response type [%s]", interceptedQuery.getQueryName(), interceptedQuery.getResponseType()));
            }
            Iterator<MessageHandler<QueryMessage<?, ?>>> handlerIterator = handlers.iterator();
            boolean invocationSuccess = false;
            while (!invocationSuccess && handlerIterator.hasNext()) {
                DefaultUnitOfWork<QueryMessage<Q, R>> uow = DefaultUnitOfWork.startAndGet(interceptedQuery);
                ResultMessage<CompletableFuture<QueryResponseMessage<R>>> resultMessage = this.interceptAndInvoke(uow, handlerIterator.next());
                if (resultMessage.isExceptional()) {
                    if (resultMessage.exceptionResult() instanceof NoHandlerForQueryException) continue;
                    result.complete(new GenericQueryResponseMessage<R>(interceptedQuery.getResponseType().responseMessagePayloadType(), resultMessage.exceptionResult()));
                    monitorCallback.reportFailure(resultMessage.exceptionResult());
                    return result;
                }
                result = (CompletableFuture)resultMessage.getPayload();
                invocationSuccess = true;
            }
            if (!invocationSuccess) {
                throw new NoHandlerForQueryException(String.format("No suitable handler was found for [%s] with response type [%s]", interceptedQuery.getQueryName(), interceptedQuery.getResponseType()));
            }
            monitorCallback.reportSuccess();
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            monitorCallback.reportFailure(e);
        }
        return result;
    }

    @Override
    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(QueryMessage<Q, R> query, long timeout, TimeUnit unit) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(query);
        QueryMessage interceptedQuery = this.intercept(query);
        List<MessageHandler<QueryMessage<?, ?>>> handlers = this.getHandlersForMessage(interceptedQuery);
        if (handlers.isEmpty()) {
            monitorCallback.reportIgnored();
            return Stream.empty();
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        return handlers.stream().map(handler -> {
            long leftTimeout = ObjectUtils.getRemainingOfDeadline(deadline);
            ResultMessage resultMessage = this.interceptAndInvoke(DefaultUnitOfWork.startAndGet(interceptedQuery), (MessageHandler)handler);
            QueryResponseMessage response = null;
            if (resultMessage.isExceptional()) {
                monitorCallback.reportFailure(resultMessage.exceptionResult());
                this.errorHandler.onError(resultMessage.exceptionResult(), interceptedQuery, (MessageHandler)handler);
            } else {
                try {
                    response = (QueryResponseMessage)((CompletableFuture)resultMessage.getPayload()).get(leftTimeout, TimeUnit.MILLISECONDS);
                    monitorCallback.reportSuccess();
                }
                catch (Exception e) {
                    monitorCallback.reportFailure(e);
                    this.errorHandler.onError(e, interceptedQuery, (MessageHandler)handler);
                }
            }
            return response;
        }).filter(Objects::nonNull);
    }

    @Override
    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(SubscriptionQueryMessage<Q, I, U> query, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        if (this.queryUpdateEmitter.queryUpdateHandlerRegistered(query)) {
            throw new IllegalArgumentException("There is already a subscription with the given message identifier");
        }
        MonoWrapper initialResult = MonoWrapper.create(monoSink -> ((CompletableFuture)this.query(query).thenAccept(queryResponseMessage -> {
            if (queryResponseMessage.isExceptional()) {
                Throwable exceptionResult = queryResponseMessage.exceptionResult();
                logger.error(String.format("An error happened while trying to report an initial result. Query: %s", query), exceptionResult);
                monoSink.error(exceptionResult);
            } else {
                monoSink.success(queryResponseMessage);
            }
        })).exceptionally(t -> {
            logger.error(String.format("An error happened while trying to report an initial result. Query: %s", query), t);
            monoSink.error(t.getCause());
            return null;
        }));
        UpdateHandlerRegistration updateHandlerRegistration = this.queryUpdateEmitter.registerUpdateHandler(query, backpressure, updateBufferSize);
        return new DefaultSubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>>(initialResult.getMono(), updateHandlerRegistration.getUpdates(), updateHandlerRegistration.getRegistration());
    }

    @Override
    public QueryUpdateEmitter queryUpdateEmitter() {
        return this.queryUpdateEmitter;
    }

    private <Q, R> ResultMessage<CompletableFuture<QueryResponseMessage<R>>> interceptAndInvoke(UnitOfWork<QueryMessage<Q, R>> uow, MessageHandler<? super QueryMessage<?, R>> handler) {
        return uow.executeWithResult(() -> {
            ResponseType responseType = ((QueryMessage)uow.getMessage()).getResponseType();
            Object queryResponse = new DefaultInterceptorChain(uow, this.handlerInterceptors, handler).proceed();
            if (queryResponse instanceof CompletableFuture) {
                return ((CompletableFuture)queryResponse).thenCompose(result -> this.buildCompletableFuture(responseType, result));
            }
            if (queryResponse instanceof Future) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return (QueryResponseMessage)((Future)queryResponse).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new QueryExecutionException("Error happened while trying to execute query handler", e);
                    }
                });
            }
            return this.buildCompletableFuture(responseType, queryResponse);
        });
    }

    private <R> CompletableFuture<QueryResponseMessage<R>> buildCompletableFuture(ResponseType<R> responseType, Object queryResponse) {
        return CompletableFuture.completedFuture(GenericQueryResponseMessage.asNullableResponseMessage(responseType.responseMessagePayloadType(), responseType.convert(queryResponse)));
    }

    private <Q, R, T extends QueryMessage<Q, R>> T intercept(T query) {
        Object intercepted = query;
        for (MessageDispatchInterceptor<QueryMessage<?, ?>> interceptor : this.dispatchInterceptors) {
            intercepted = interceptor.handle((QueryMessage<?, ?>)intercepted);
        }
        return intercepted;
    }

    protected Map<String, Collection<QuerySubscription>> getSubscriptions() {
        return Collections.unmodifiableMap(this.subscriptions);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super QueryMessage<?, ?>> interceptor) {
        this.handlerInterceptors.add(interceptor);
        return () -> this.handlerInterceptors.remove(interceptor);
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super QueryMessage<?, ?>> interceptor) {
        this.dispatchInterceptors.add(interceptor);
        return () -> this.dispatchInterceptors.remove(interceptor);
    }

    private <Q, R> List<MessageHandler<? super QueryMessage<?, ?>>> getHandlersForMessage(QueryMessage<Q, R> queryMessage) {
        ResponseType responseType = queryMessage.getResponseType();
        return this.subscriptions.computeIfAbsent(queryMessage.getQueryName(), k -> new CopyOnWriteArrayList()).stream().filter(querySubscription -> responseType.matches(querySubscription.getResponseType())).map(QuerySubscription::getQueryHandler).map(queryHandler -> queryHandler).collect(Collectors.toList());
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }

    public static class Builder {
        private MessageMonitor<? super QueryMessage<?, ?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
        private TransactionManager transactionManager = NoTransactionManager.instance();
        private QueryInvocationErrorHandler errorHandler = LoggingQueryInvocationErrorHandler.builder().logger(SimpleQueryBus.access$400()).build();
        private QueryUpdateEmitter queryUpdateEmitter = SimpleQueryUpdateEmitter.builder().build();

        public Builder messageMonitor(MessageMonitor<? super QueryMessage<?, ?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder errorHandler(QueryInvocationErrorHandler errorHandler) {
            BuilderUtils.assertNonNull(errorHandler, "QueryInvocationErrorHandler may not be null");
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder queryUpdateEmitter(QueryUpdateEmitter queryUpdateEmitter) {
            BuilderUtils.assertNonNull(queryUpdateEmitter, "QueryUpdateEmitter may not be null");
            this.queryUpdateEmitter = queryUpdateEmitter;
            return this;
        }

        public SimpleQueryBus build() {
            return new SimpleQueryBus(this);
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

