/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.axonframework.eventhandling.scheduling.ScheduleToken;

public class QuartzScheduleToken
implements ScheduleToken {
    private static final long serialVersionUID = 7798276124742118925L;
    private final String jobIdentifier;
    private final String groupIdentifier;

    @JsonCreator
    public QuartzScheduleToken(@JsonProperty(value="jobIdentifier") String jobIdentifier, @JsonProperty(value="groupIdentifier") String groupIdentifier) {
        this.jobIdentifier = jobIdentifier;
        this.groupIdentifier = groupIdentifier;
    }

    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public String toString() {
        return String.format("Quartz Schedule token for job [%s] in group [%s]", this.jobIdentifier, this.groupIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.groupIdentifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuartzScheduleToken other = (QuartzScheduleToken)obj;
        return Objects.equals(this.jobIdentifier, other.jobIdentifier) && Objects.equals(this.groupIdentifier, other.groupIdentifier);
    }
}

