/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.LongStream;
import org.axonframework.common.Assert;
import org.axonframework.common.CollectionUtils;
import org.axonframework.eventhandling.TrackingToken;

public class GapAwareTrackingToken
implements TrackingToken,
Serializable {
    private final long index;
    private final SortedSet<Long> gaps;

    @JsonCreator
    public static GapAwareTrackingToken newInstance(@JsonProperty(value="index") long index, @JsonProperty(value="gaps") Collection<Long> gaps) {
        if (gaps.isEmpty()) {
            return new GapAwareTrackingToken(index, Collections.emptySortedSet());
        }
        ConcurrentSkipListSet<Long> gapSet = new ConcurrentSkipListSet<Long>(gaps);
        Assert.isTrue((Long)gapSet.last() < index, () -> String.format("Gap indices [%s] should all be smaller than head index [%d]", gaps, index));
        return new GapAwareTrackingToken(index, gapSet);
    }

    private GapAwareTrackingToken(long index, SortedSet<Long> gaps) {
        this.index = index;
        this.gaps = gaps;
    }

    public GapAwareTrackingToken advanceTo(long index, int maxGapOffset, boolean allowGaps) {
        long newIndex;
        ConcurrentSkipListSet<Long> gaps = new ConcurrentSkipListSet<Long>(this.gaps);
        if (gaps.remove(index)) {
            newIndex = this.index;
        } else if (index > this.index) {
            newIndex = index;
            LongStream.range(this.index + 1L, index).forEach(gaps::add);
        } else {
            throw new IllegalArgumentException(String.format("The given index [%d] should be larger than the token index [%d] or be one of the token's gaps [%s]", index, this.index, gaps));
        }
        long smalledAllowedGap = allowGaps ? newIndex - (long)maxGapOffset : Math.max(index, newIndex - (long)maxGapOffset);
        gaps.removeAll(gaps.headSet(smalledAllowedGap));
        return new GapAwareTrackingToken(newIndex, gaps);
    }

    public long getIndex() {
        return this.index;
    }

    public SortedSet<Long> getGaps() {
        return Collections.unmodifiableSortedSet(this.gaps);
    }

    @Override
    public GapAwareTrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue(other instanceof GapAwareTrackingToken, () -> "Incompatible token type provided.");
        GapAwareTrackingToken otherToken = (GapAwareTrackingToken)other;
        ConcurrentSkipListSet<Long> mergedGaps = new ConcurrentSkipListSet<Long>(this.gaps);
        mergedGaps.addAll(otherToken.gaps);
        long mergedIndex = this.calculateIndex(otherToken, mergedGaps);
        mergedGaps.removeIf(i -> i >= mergedIndex);
        return new GapAwareTrackingToken(mergedIndex, mergedGaps);
    }

    @Override
    public TrackingToken upperBound(TrackingToken otherToken) {
        Assert.isTrue(otherToken instanceof GapAwareTrackingToken, () -> "Incompatible token type provided.");
        GapAwareTrackingToken other = (GapAwareTrackingToken)otherToken;
        SortedSet newGaps = CollectionUtils.intersect(this.gaps, other.gaps, ConcurrentSkipListSet::new);
        long min = Math.min(this.index, other.index) + 1L;
        SortedSet mergedGaps = CollectionUtils.merge(this.gaps.tailSet(min), other.gaps.tailSet(min), ConcurrentSkipListSet::new);
        newGaps.addAll(mergedGaps);
        return new GapAwareTrackingToken(Math.max(this.index, other.index), newGaps);
    }

    private long calculateIndex(GapAwareTrackingToken otherToken, SortedSet<Long> mergedGaps) {
        long mergedIndex = Math.min(this.index, otherToken.index);
        while (mergedGaps.contains(mergedIndex)) {
            --mergedIndex;
        }
        return mergedIndex;
    }

    @Override
    public boolean covers(TrackingToken other) {
        Assert.isTrue(other instanceof GapAwareTrackingToken, () -> "Incompatible token type provided.");
        GapAwareTrackingToken otherToken = (GapAwareTrackingToken)other;
        return otherToken.index <= this.index && !this.gaps.contains(otherToken.index) && otherToken.gaps.containsAll(this.gaps.headSet(otherToken.index));
    }

    public boolean hasGaps() {
        return !this.gaps.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GapAwareTrackingToken that = (GapAwareTrackingToken)o;
        return this.index == that.index && Objects.equals(this.gaps, that.gaps);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.gaps);
    }

    public String toString() {
        return "GapAwareTrackingToken{index=" + this.index + ", gaps=" + this.gaps + '}';
    }
}

