/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.quartz;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlineJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(DeadlineJob.class);
    public static final String TRANSACTION_MANAGER_KEY = TransactionManager.class.getName();
    public static final String SCOPE_AWARE_RESOLVER = ScopeAwareProvider.class.getName();
    public static final String JOB_DATA_SERIALIZER = Serializer.class.getName();
    public static final String HANDLER_INTERCEPTORS = MessageHandlerInterceptor.class.getName();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting a deadline job");
        }
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobData = jobDetail.getJobDataMap();
        try {
            SchedulerContext schedulerContext = context.getScheduler().getContext();
            Serializer serializer = (Serializer)schedulerContext.get((Object)JOB_DATA_SERIALIZER);
            TransactionManager transactionManager = (TransactionManager)schedulerContext.get((Object)TRANSACTION_MANAGER_KEY);
            ScopeAwareProvider scopeAwareComponents = (ScopeAwareProvider)schedulerContext.get((Object)SCOPE_AWARE_RESOLVER);
            List handlerInterceptors = (List)schedulerContext.get((Object)HANDLER_INTERCEPTORS);
            DeadlineMessage deadlineMessage = DeadlineJobDataBinder.deadlineMessage(serializer, jobData);
            ScopeDescriptor deadlineScope = DeadlineJobDataBinder.deadlineScope(serializer, jobData);
            DefaultUnitOfWork<DeadlineMessage> unitOfWork = DefaultUnitOfWork.startAndGet(deadlineMessage);
            unitOfWork.attachTransaction(transactionManager);
            DefaultInterceptorChain<DeadlineMessage> chain = new DefaultInterceptorChain<DeadlineMessage>(unitOfWork, handlerInterceptors, interceptedDeadlineMessage -> {
                this.executeScheduledDeadline(scopeAwareComponents, (DeadlineMessage)interceptedDeadlineMessage, deadlineScope);
                return null;
            });
            ResultMessage<Object> resultMessage = unitOfWork.executeWithResult(chain::proceed);
            if (resultMessage.isExceptional()) {
                throw resultMessage.exceptionResult();
            }
            if (logger.isInfoEnabled()) {
                logger.info("Job successfully executed. Deadline message [{}] processed.", (Object)deadlineMessage.getPayloadType().getSimpleName());
            }
        }
        catch (Throwable e) {
            logger.error("Exception occurred during processing a deadline job [{}]", (Object)jobDetail.getDescription(), (Object)e);
            throw new JobExecutionException(e);
        }
    }

    private void executeScheduledDeadline(ScopeAwareProvider scopeAwareComponents, DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope) {
        scopeAwareComponents.provideScopeAwareStream(deadlineScope).filter(scopeAwareComponent -> scopeAwareComponent.canResolve(deadlineScope)).forEach(scopeAwareComponent -> {
            try {
                scopeAwareComponent.send(deadlineMessage, deadlineScope);
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Failed to send a DeadlineMessage for scope [%s]", deadlineScope.scopeDescription());
                throw new ExecutionException(exceptionMessage, e);
            }
        });
    }

    public static class DeadlineJobDataBinder {
        @Deprecated
        public static final String SERIALIZED_DEADLINE_MESSAGE = "serializedDeadlineMessage";
        @Deprecated
        public static final String SERIALIZED_DEADLINE_MESSAGE_CLASS_NAME = "serializedDeadlineMessageClassName";
        public static final String SERIALIZED_DEADLINE_SCOPE = "serializedDeadlineScope";
        public static final String SERIALIZED_DEADLINE_SCOPE_CLASS_NAME = "serializedDeadlineScopeClassName";

        public static JobDataMap toJobData(Serializer serializer, DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope) {
            JobDataMap jobData = new JobDataMap();
            DeadlineJobDataBinder.putDeadlineMessage(jobData, deadlineMessage, serializer);
            DeadlineJobDataBinder.putDeadlineScope(jobData, deadlineScope, serializer);
            return jobData;
        }

        private static void putDeadlineMessage(JobDataMap jobData, DeadlineMessage deadlineMessage, Serializer serializer) {
            jobData.put("axon-deadline-name", deadlineMessage.getDeadlineName());
            jobData.put("axon-message-id", deadlineMessage.getIdentifier());
            jobData.put("axon-message-timestamp", deadlineMessage.getTimestamp().toEpochMilli());
            SerializedObject<byte[]> serializedDeadlinePayload = serializer.serialize(deadlineMessage.getPayload(), byte[].class);
            jobData.put("axon-serialized-message-payload", (Object)serializedDeadlinePayload.getData());
            jobData.put("axon-message-type", serializedDeadlinePayload.getType().getName());
            jobData.put("axon-message-revision", serializedDeadlinePayload.getType().getRevision());
            SerializedObject<byte[]> serializedDeadlineMetaData = serializer.serialize(deadlineMessage.getMetaData(), byte[].class);
            jobData.put("axon-metadata", (Object)serializedDeadlineMetaData.getData());
        }

        private static void putDeadlineScope(JobDataMap jobData, ScopeDescriptor deadlineScope, Serializer serializer) {
            SerializedObject<byte[]> serializedDeadlineScope = serializer.serialize(deadlineScope, byte[].class);
            jobData.put(SERIALIZED_DEADLINE_SCOPE, (Object)serializedDeadlineScope.getData());
            jobData.put(SERIALIZED_DEADLINE_SCOPE_CLASS_NAME, serializedDeadlineScope.getType().getName());
        }

        public static DeadlineMessage deadlineMessage(Serializer serializer, JobDataMap jobDataMap) {
            if (jobDataMap.containsKey((Object)SERIALIZED_DEADLINE_MESSAGE)) {
                SimpleSerializedObject<byte[]> serializedDeadlineMessage = new SimpleSerializedObject<byte[]>((byte[])jobDataMap.get((Object)SERIALIZED_DEADLINE_MESSAGE), byte[].class, (String)jobDataMap.get((Object)SERIALIZED_DEADLINE_MESSAGE_CLASS_NAME), null);
                return (DeadlineMessage)serializer.deserialize(serializedDeadlineMessage);
            }
            return new GenericDeadlineMessage<Object>((String)jobDataMap.get((Object)"axon-deadline-name"), (String)jobDataMap.get((Object)"axon-message-id"), DeadlineJobDataBinder.deserializeDeadlinePayload(serializer, jobDataMap), DeadlineJobDataBinder.deserializeDeadlineMetaData(serializer, jobDataMap), DeadlineJobDataBinder.retrieveDeadlineTimestamp(jobDataMap));
        }

        private static Object deserializeDeadlinePayload(Serializer serializer, JobDataMap jobDataMap) {
            SimpleSerializedObject<byte[]> serializedDeadlinePayload = new SimpleSerializedObject<byte[]>((byte[])jobDataMap.get((Object)"axon-serialized-message-payload"), byte[].class, (String)jobDataMap.get((Object)"axon-message-type"), (String)jobDataMap.get((Object)"axon-message-revision"));
            return serializer.deserialize(serializedDeadlinePayload);
        }

        private static Map<String, ?> deserializeDeadlineMetaData(Serializer serializer, JobDataMap jobDataMap) {
            SimpleSerializedObject<byte[]> serializedDeadlineMetaData = new SimpleSerializedObject<byte[]>((byte[])jobDataMap.get((Object)"axon-metadata"), byte[].class, MetaData.class.getName(), null);
            return (Map)serializer.deserialize(serializedDeadlineMetaData);
        }

        private static Instant retrieveDeadlineTimestamp(JobDataMap jobDataMap) {
            return Instant.ofEpochMilli((Long)jobDataMap.get((Object)"axon-message-timestamp"));
        }

        public static ScopeDescriptor deadlineScope(Serializer serializer, JobDataMap jobDataMap) {
            SimpleSerializedObject<byte[]> serializedDeadlineScope = new SimpleSerializedObject<byte[]>((byte[])jobDataMap.get((Object)SERIALIZED_DEADLINE_SCOPE), byte[].class, (String)jobDataMap.get((Object)SERIALIZED_DEADLINE_SCOPE_CLASS_NAME), null);
            return (ScopeDescriptor)serializer.deserialize(serializedDeadlineScope);
        }
    }
}

