/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import org.axonframework.common.DateTimeUtils;

@Entity
@Table(indexes={@Index(columnList="aggregateIdentifier,aggregateSequenceNumber", unique=true)})
public class AggregateEventEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="globalIndexGenerator")
    @SequenceGenerator(name="globalIndexGenerator", sequenceName="aggregate-event-global-index-sequence", allocationSize=1)
    private long globalIndex;
    private String aggregateType;
    private String aggregateIdentifier;
    private Long aggregateSequenceNumber;
    @Basic(optional=false)
    private String type;
    @Basic(optional=false)
    private String version;
    @Basic(optional=false)
    private String timestamp;
    @Basic(optional=false)
    @Lob
    private byte[] payload;
    @Lob
    private byte[] metadata;
    @Column(nullable=false, unique=true)
    private String identifier;

    public AggregateEventEntry(@Nonnull String identifier, @Nonnull String type, @Nonnull String version, @Nonnull byte[] payload, @Nonnull byte[] metadata, @Nonnull Object timestamp, @Nullable String aggregateType, @Nullable String aggregateIdentifier, @Nullable Long aggregateSequenceNumber) {
        this.identifier = identifier;
        this.type = type;
        this.version = version;
        this.payload = payload;
        this.metadata = metadata;
        this.timestamp = timestamp instanceof TemporalAccessor ? DateTimeUtils.formatInstant((TemporalAccessor)((TemporalAccessor)timestamp)) : timestamp.toString();
        this.aggregateType = aggregateType;
        this.aggregateIdentifier = aggregateIdentifier;
        this.aggregateSequenceNumber = aggregateSequenceNumber;
    }

    public AggregateEventEntry(long globalIndex, @Nonnull String identifier, @Nonnull String type, @Nonnull String version, @Nonnull byte[] payload, @Nonnull byte[] metadata, @Nonnull String timestamp, @Nullable String aggregateType, @Nullable String aggregateIdentifier, @Nullable Long aggregateSequenceNumber) {
        this.globalIndex = globalIndex;
        this.identifier = identifier;
        this.type = type;
        this.version = version;
        this.payload = payload;
        this.metadata = metadata;
        this.timestamp = timestamp;
        this.aggregateType = aggregateType;
        this.aggregateIdentifier = aggregateIdentifier;
        this.aggregateSequenceNumber = aggregateSequenceNumber;
    }

    protected AggregateEventEntry() {
    }

    public long globalIndex() {
        return this.globalIndex;
    }

    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Nonnull
    public String type() {
        return this.type;
    }

    @Nonnull
    public String version() {
        return this.version;
    }

    @Nonnull
    public byte[] payload() {
        return this.payload;
    }

    @Nonnull
    public byte[] metadata() {
        return this.metadata;
    }

    @Nonnull
    public Instant timestamp() {
        return DateTimeUtils.parseInstant((CharSequence)this.timestamp);
    }

    @Nonnull
    public String timestampAsString() {
        return this.timestamp;
    }

    @Nullable
    public String aggregateType() {
        return this.aggregateType;
    }

    @Nullable
    public String aggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Nullable
    public Long aggregateSequenceNumber() {
        return this.aggregateSequenceNumber;
    }
}

