/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.axonframework.common.CollectionUtils;
import org.axonframework.eventsourcing.eventstore.AbstractConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.AggregateSequenceNumberPosition;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.Position;

public class AggregateBasedConsistencyMarker
extends AbstractConsistencyMarker<AggregateBasedConsistencyMarker> {
    private final Map<String, Long> aggregatePositions;

    public AggregateBasedConsistencyMarker(String aggregateIdentifier, long sequenceNumber) {
        this(Map.of(aggregateIdentifier, sequenceNumber));
    }

    private AggregateBasedConsistencyMarker(Map<String, Long> aggregatePositions) {
        this.aggregatePositions = aggregatePositions;
    }

    public static AggregateBasedConsistencyMarker from(AppendCondition appendCondition) {
        ConsistencyMarker consistencyMarker = appendCondition.consistencyMarker();
        if (consistencyMarker instanceof AggregateBasedConsistencyMarker) {
            AggregateBasedConsistencyMarker abcm = (AggregateBasedConsistencyMarker)consistencyMarker;
            return abcm;
        }
        if (appendCondition.criteria().hasCriteria() && appendCondition.consistencyMarker() == INFINITY) {
            throw new IllegalArgumentException("Consistency marker must not be infinity when criteria are provided");
        }
        if (appendCondition.consistencyMarker() == ORIGIN || appendCondition.consistencyMarker() == INFINITY) {
            return new AggregateBasedConsistencyMarker(Map.of());
        }
        throw new IllegalArgumentException("Unsupported consistency marker: " + String.valueOf(appendCondition.consistencyMarker()));
    }

    public AggregateBasedConsistencyMarker doLowerBound(AggregateBasedConsistencyMarker other) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AggregateBasedConsistencyMarker doUpperBound(AggregateBasedConsistencyMarker other) {
        HashMap<String, Long> newPositions = new HashMap<String, Long>(this.aggregatePositions);
        other.aggregatePositions.forEach((id, seq) -> {
            if (!newPositions.containsKey(id) || (Long)newPositions.get(id) < seq) {
                newPositions.put((String)id, (Long)seq);
            }
        });
        return new AggregateBasedConsistencyMarker(newPositions);
    }

    @Override
    public Position position() {
        if (this.aggregatePositions.size() > 1) {
            throw new IllegalStateException("ConsistencyMarker contains multiple positions, unable to convert to single position: " + String.valueOf(this));
        }
        return new AggregateSequenceNumberPosition(this.aggregatePositions.values().iterator().next());
    }

    private AggregateBasedConsistencyMarker forwarded(String aggregateIdentifier, long newSequence) {
        long current = this.aggregatePositions.getOrDefault(aggregateIdentifier, -1L);
        if (current > newSequence) {
            throw new IllegalArgumentException("Aggregate " + aggregateIdentifier + " is already beyond provided position. Current position: " + current + ", provided: " + newSequence);
        }
        if (current == newSequence) {
            return this;
        }
        Map newMap = CollectionUtils.mapWith(this.aggregatePositions, (Object)aggregateIdentifier, (Object)newSequence);
        return new AggregateBasedConsistencyMarker(newMap);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AggregateBasedConsistencyMarker)) {
            return false;
        }
        AggregateBasedConsistencyMarker that = (AggregateBasedConsistencyMarker)o;
        return Objects.equals(this.aggregatePositions, that.aggregatePositions);
    }

    public int hashCode() {
        return Objects.hashCode(this.aggregatePositions);
    }

    public String toString() {
        return "AggregateBasedConsistencyMarker{aggregatePositions=" + String.valueOf(this.aggregatePositions) + "}";
    }

    public AggregateSequencer createSequencer() {
        return new AggregateSequencer();
    }

    public final class AggregateSequencer {
        private final Map<String, Long> aggregateSequences = new HashMap<String, Long>();

        private AggregateSequencer() {
        }

        public AggregateBasedConsistencyMarker toMarker() {
            AggregateBasedConsistencyMarker newConsistencyMarker = AggregateBasedConsistencyMarker.this;
            for (Map.Entry<String, Long> e : this.aggregateSequences.entrySet()) {
                newConsistencyMarker = newConsistencyMarker.forwarded(e.getKey(), e.getValue());
            }
            return newConsistencyMarker;
        }

        public long incrementAndGetSequenceOf(String aggregateIdentifier) {
            return this.aggregateSequences.compute(aggregateIdentifier, (key, oldValue) -> oldValue == null ? this.positionOf((String)key) + 1L : oldValue + 1L);
        }

        private long positionOf(@Nonnull String aggregateIdentifier) {
            return AggregateBasedConsistencyMarker.this.aggregatePositions.getOrDefault(aggregateIdentifier, -1L);
        }
    }
}

