/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventsourcing.eventstore.jpa.AggregateEventEntry;

public record AggregateBasedJpaEventStorageEngineConfiguration(@Nullable PersistenceExceptionResolver persistenceExceptionResolver, @Nonnull Predicate<List<? extends AggregateEventEntry>> finalBatchPredicate, int batchSize, int gapCleaningThreshold, int maxGapOffset, long lowestGlobalSequence, int gapTimeout) {
    private static final Predicate<List<? extends AggregateEventEntry>> DEFAULT_BATCH_PREDICATE = List::isEmpty;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    public static final AggregateBasedJpaEventStorageEngineConfiguration DEFAULT = new AggregateBasedJpaEventStorageEngineConfiguration(null, DEFAULT_BATCH_PREDICATE, 100, 250, 10000, 1L, 60000);

    public AggregateBasedJpaEventStorageEngineConfiguration {
        Objects.requireNonNull(finalBatchPredicate, "The finalBatchPredicate must not be null.");
        BuilderUtils.assertStrictPositive((int)batchSize, (String)"The batchSize must be a positive number.");
        BuilderUtils.assertPositive((int)gapCleaningThreshold, (String)"gapCleaningThreshold");
        BuilderUtils.assertPositive((int)maxGapOffset, (String)"The maxGapOffset must be a positive number.");
        BuilderUtils.assertPositive((long)lowestGlobalSequence, (String)"The lowestGlobalSequence must be a positive number.");
        BuilderUtils.assertPositive((int)gapTimeout, (String)"gapTimeout");
    }

    public AggregateBasedJpaEventStorageEngineConfiguration persistenceExceptionResolver(@Nullable PersistenceExceptionResolver persistenceExceptionResolver) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(persistenceExceptionResolver, this.finalBatchPredicate, this.batchSize, this.gapCleaningThreshold, this.maxGapOffset, this.lowestGlobalSequence, this.gapTimeout);
    }

    public AggregateBasedJpaEventStorageEngineConfiguration finalBatchPredicate(@Nonnull Predicate<List<? extends AggregateEventEntry>> finalBatchPredicate) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(this.persistenceExceptionResolver, finalBatchPredicate, this.batchSize, this.gapCleaningThreshold, this.maxGapOffset, this.lowestGlobalSequence, this.gapTimeout);
    }

    public AggregateBasedJpaEventStorageEngineConfiguration batchSize(int batchSize) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(this.persistenceExceptionResolver, this.finalBatchPredicate, batchSize, this.gapCleaningThreshold, this.maxGapOffset, this.lowestGlobalSequence, this.gapTimeout);
    }

    public AggregateBasedJpaEventStorageEngineConfiguration gapCleaningThreshold(int gapCleaningThreshold) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(this.persistenceExceptionResolver, this.finalBatchPredicate, this.batchSize, gapCleaningThreshold, this.maxGapOffset, this.lowestGlobalSequence, this.gapTimeout);
    }

    public AggregateBasedJpaEventStorageEngineConfiguration maxGapOffset(int maxGapOffset) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(this.persistenceExceptionResolver, this.finalBatchPredicate, this.batchSize, this.gapCleaningThreshold, maxGapOffset, this.lowestGlobalSequence, this.gapTimeout);
    }

    public AggregateBasedJpaEventStorageEngineConfiguration lowestGlobalSequence(long lowestGlobalSequence) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(this.persistenceExceptionResolver, this.finalBatchPredicate, this.batchSize, this.gapCleaningThreshold, this.maxGapOffset, lowestGlobalSequence, this.gapTimeout);
    }

    public AggregateBasedJpaEventStorageEngineConfiguration gapTimeout(int gapTimeout) {
        return new AggregateBasedJpaEventStorageEngineConfiguration(this.persistenceExceptionResolver, this.finalBatchPredicate, this.batchSize, this.gapCleaningThreshold, this.maxGapOffset, this.lowestGlobalSequence, gapTimeout);
    }
}

