/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.common.annotations.Internal;

@Internal
public class StreamSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final Function<T, List<? extends T>> fetchFunction;
    private final Predicate<List<? extends T>> finalFetchPredicate;
    private Iterator<? extends T> iterator;
    private T lastItem;
    private boolean finalFetch;

    public StreamSpliterator(@Nonnull Function<T, List<? extends T>> fetchFunction, @Nonnull Predicate<List<? extends T>> finalFetchPredicate) {
        super(Long.MAX_VALUE, 4369);
        this.fetchFunction = fetchFunction;
        this.finalFetchPredicate = finalFetchPredicate;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.iterator == null || !this.iterator.hasNext()) {
            if (this.finalFetch) {
                return false;
            }
            List<T> items = this.fetchFunction.apply(this.lastItem);
            this.finalFetch = this.finalFetchPredicate.test(items);
            this.iterator = items.iterator();
        }
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.lastItem = this.iterator.next();
        action.accept(this.lastItem);
        return true;
    }
}

