/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.common.Registration;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.InterceptingEventBus;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.DefaultMessageDispatchInterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class InterceptingEventStore
implements EventStore {
    public static final int DECORATION_ORDER = -2147483598;
    private final EventStore delegate;
    private final List<MessageDispatchInterceptor<? super EventMessage>> interceptors;
    private final InterceptingAppender interceptingAppender;
    private final InterceptingEventBus delegateBus;
    private final Context.ResourceKey<EventStoreTransaction> delegateTransactionKey = Context.ResourceKey.withLabel((String)"delegateTransaction");
    private final Context.ResourceKey<EventStoreTransaction> interceptingTransactionKey = Context.ResourceKey.withLabel((String)"interceptingTransaction");

    @Internal
    public InterceptingEventStore(@Nonnull EventStore delegate, @Nonnull List<MessageDispatchInterceptor<? super EventMessage>> interceptors) {
        this.delegate = Objects.requireNonNull(delegate, "The EventStore may not be null.");
        this.interceptors = Objects.requireNonNull(interceptors, "The dispatch interceptors must not be null.");
        this.interceptingAppender = new InterceptingAppender(interceptors, context -> (EventStoreTransaction)context.getResource(this.delegateTransactionKey));
        this.delegateBus = new InterceptingEventBus((EventBus)delegate, interceptors);
    }

    @Override
    public EventStoreTransaction transaction(@Nonnull ProcessingContext processingContext) {
        EventStoreTransaction delegateTransaction = this.getAndSetDelegateTransaction(processingContext);
        return (EventStoreTransaction)processingContext.computeResourceIfAbsent(this.interceptingTransactionKey, () -> new InterceptingEventStoreTransaction(processingContext, delegateTransaction));
    }

    private EventStoreTransaction getAndSetDelegateTransaction(@Nonnull ProcessingContext context) {
        EventStoreTransaction delegateTransaction;
        if (context.containsResource(this.delegateTransactionKey)) {
            delegateTransaction = (EventStoreTransaction)context.getResource(this.delegateTransactionKey);
        } else {
            delegateTransaction = this.delegate.transaction(context);
            context.putResourceIfAbsent(this.delegateTransactionKey, (Object)delegateTransaction);
        }
        return delegateTransaction;
    }

    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        return this.delegateBus.publish(context, events);
    }

    public MessageStream<EventMessage> open(@Nonnull StreamingCondition condition, @Nullable ProcessingContext context) {
        return this.delegate.open(condition, context);
    }

    public CompletableFuture<TrackingToken> firstToken(@Nullable ProcessingContext context) {
        return this.delegate.firstToken(context);
    }

    public CompletableFuture<TrackingToken> latestToken(@Nullable ProcessingContext context) {
        return this.delegate.latestToken(context);
    }

    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant at, @Nullable ProcessingContext context) {
        return this.delegate.tokenAt(at, context);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
        descriptor.describeProperty("dispatchInterceptors", this.interceptors);
        descriptor.describeProperty("delegateBus", (Object)this.delegateBus);
    }

    public Registration subscribe(@Nonnull BiFunction<List<? extends EventMessage>, ProcessingContext, CompletableFuture<?>> eventsBatchConsumer) {
        return this.delegate.subscribe(eventsBatchConsumer);
    }

    private static class InterceptingAppender {
        private final DefaultMessageDispatchInterceptorChain<? super EventMessage> interceptorChain;

        private InterceptingAppender(List<MessageDispatchInterceptor<? super EventMessage>> interceptors, Function<ProcessingContext, EventStoreTransaction> transactionProvider) {
            this.interceptorChain = new DefaultMessageDispatchInterceptorChain(interceptors, (event, context) -> {
                ((EventStoreTransaction)transactionProvider.apply((ProcessingContext)context)).appendEvent((EventMessage)event);
                return MessageStream.empty();
            });
        }

        private void interceptAndAppend(@Nonnull EventMessage event, @Nullable ProcessingContext context) {
            this.interceptorChain.proceed((Message)event, context).ignoreEntries().asCompletableFuture().join();
        }
    }

    private class InterceptingEventStoreTransaction
    implements EventStoreTransaction {
        private final ProcessingContext context;
        private final EventStoreTransaction delegate;

        private InterceptingEventStoreTransaction(@Nonnull ProcessingContext context, EventStoreTransaction delegate) {
            this.delegate = delegate;
            this.context = context;
        }

        @Override
        public MessageStream<? extends EventMessage> source(@Nonnull SourcingCondition condition) {
            return this.delegate.source(condition);
        }

        @Override
        public void appendEvent(@Nonnull EventMessage eventMessage) {
            InterceptingEventStore.this.interceptingAppender.interceptAndAppend(eventMessage, this.context);
        }

        @Override
        public void onAppend(@Nonnull Consumer<EventMessage> callback) {
            this.delegate.onAppend(callback);
        }

        @Override
        public ConsistencyMarker appendPosition() {
            return this.delegate.appendPosition();
        }
    }
}

