/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;

abstract class ConsistencyMarkers {
    ConsistencyMarkers() {
    }

    static class InfinityConsistencyMarker
    implements ConsistencyMarker {
        static final InfinityConsistencyMarker INSTANCE = new InfinityConsistencyMarker();

        private InfinityConsistencyMarker() {
        }

        @Override
        public ConsistencyMarker lowerBound(@Nonnull ConsistencyMarker other) {
            return Objects.requireNonNull(other, "The consistency marker cannot be null.");
        }

        @Override
        public ConsistencyMarker upperBound(@Nonnull ConsistencyMarker other) {
            return this;
        }

        public String toString() {
            return "INFINITY";
        }
    }

    static class OriginConsistencyMarker
    implements ConsistencyMarker {
        static final OriginConsistencyMarker INSTANCE = new OriginConsistencyMarker();

        private OriginConsistencyMarker() {
        }

        @Override
        public ConsistencyMarker lowerBound(@Nonnull ConsistencyMarker other) {
            return this;
        }

        @Override
        public ConsistencyMarker upperBound(@Nonnull ConsistencyMarker other) {
            return Objects.requireNonNull(other, "The other consistency marker cannot be null.");
        }

        public String toString() {
            return "ORIGIN";
        }
    }
}

