/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import org.axonframework.eventsourcing.eventstore.AbstractConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;

public class GlobalIndexConsistencyMarker
extends AbstractConsistencyMarker<GlobalIndexConsistencyMarker> {
    private final long position;

    public GlobalIndexConsistencyMarker(long position) {
        this.position = position;
    }

    public static long position(ConsistencyMarker consistencyMarker) {
        if (consistencyMarker instanceof GlobalIndexConsistencyMarker) {
            GlobalIndexConsistencyMarker gicm = (GlobalIndexConsistencyMarker)consistencyMarker;
            return gicm.position;
        }
        if (consistencyMarker == ConsistencyMarker.ORIGIN) {
            return -1L;
        }
        if (consistencyMarker == ConsistencyMarker.INFINITY) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException(String.valueOf(consistencyMarker) + " is not a global index consistency marker");
    }

    @Override
    protected ConsistencyMarker doLowerBound(GlobalIndexConsistencyMarker other) {
        return other.position < this.position ? other : this;
    }

    @Override
    protected ConsistencyMarker doUpperBound(GlobalIndexConsistencyMarker other) {
        return other.position > this.position ? other : this;
    }

    public long position() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalIndexConsistencyMarker that = (GlobalIndexConsistencyMarker)o;
        return this.position == that.position;
    }

    public int hashCode() {
        return Long.hashCode(this.position);
    }

    public String toString() {
        return "GlobalIndexConsistencyMarker{position=" + this.position + "}";
    }
}

