/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.MessageStream;

public interface EventStorageEngine
extends DescribableComponent {
    default public CompletableFuture<AppendTransaction> appendEvents(@Nonnull AppendCondition condition, TaggedEventMessage<?> ... events) {
        return this.appendEvents(condition, Arrays.asList(events));
    }

    public CompletableFuture<AppendTransaction> appendEvents(@Nonnull AppendCondition var1, @Nonnull List<TaggedEventMessage<?>> var2);

    public MessageStream<EventMessage<?>> source(@Nonnull SourcingCondition var1);

    public MessageStream<EventMessage<?>> stream(@Nonnull StreamingCondition var1);

    public CompletableFuture<TrackingToken> firstToken();

    public CompletableFuture<TrackingToken> latestToken();

    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant var1);

    public static interface AppendTransaction {
        public CompletableFuture<ConsistencyMarker> commit();

        public void rollback();
    }
}

