/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;

public abstract class AbstractConsistencyMarker<T extends ConsistencyMarker>
implements ConsistencyMarker {
    @Override
    public ConsistencyMarker lowerBound(@Nonnull ConsistencyMarker other) {
        Objects.requireNonNull(other, "The other consistency marker cannot be null.");
        if (other == ConsistencyMarker.INFINITY || other == ConsistencyMarker.ORIGIN) {
            return other.lowerBound(this);
        }
        return this.doLowerBound(other);
    }

    @Override
    public ConsistencyMarker upperBound(@Nonnull ConsistencyMarker other) {
        Objects.requireNonNull(other, "The other consistency marker cannot be null.");
        if (other == ConsistencyMarker.INFINITY || other == ConsistencyMarker.ORIGIN) {
            return other.upperBound(this);
        }
        return this.doUpperBound(other);
    }

    protected abstract ConsistencyMarker doLowerBound(T var1);

    protected abstract ConsistencyMarker doUpperBound(T var1);
}

