/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.annotation;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.annotation.EventCriteriaBuilder;
import org.axonframework.eventsourcing.annotation.EventSourcedEntity;
import org.axonframework.eventstreaming.EventCriteria;
import org.axonframework.eventstreaming.Tag;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class AnnotationBasedEventCriteriaResolver<E, ID>
implements CriteriaResolver<ID>,
DescribableComponent {
    private final Configuration configuration;
    private final Class<ID> idType;
    private final Class<E> entityType;
    private final String tagKey;
    private final Map<Class<?>, WrappedEventCriteriaBuilderMethod> builderMap;

    public AnnotationBasedEventCriteriaResolver(@Nonnull Class<E> entityType, @Nonnull Class<ID> idType, @Nonnull Configuration configuration) {
        this.entityType = Objects.requireNonNull(entityType, "The entity type cannot be null.");
        this.idType = Objects.requireNonNull(idType, "The id type cannot be null.");
        this.configuration = Objects.requireNonNull(configuration, "The configuration cannot be null.");
        Map attributes = (Map)AnnotationUtils.findAnnotationAttributes(entityType, EventSourcedEntity.class).orElseThrow(() -> new IllegalArgumentException("The given class is not an @EventSourcedEntity"));
        String annotationTagKey = (String)attributes.get("tagKey");
        this.tagKey = annotationTagKey.isEmpty() ? null : annotationTagKey;
        Map<Class, List<WrappedEventCriteriaBuilderMethod>> eventCriteriaBuilders = Arrays.stream(entityType.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(EventCriteriaBuilder.class)).map(x$0 -> new WrappedEventCriteriaBuilderMethod(this, (Method)x$0)).collect(Collectors.groupingBy(WrappedEventCriteriaBuilderMethod::getIdentifierType));
        eventCriteriaBuilders.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).findAny().ifPresent(list -> {
            throw new IllegalArgumentException("Multiple @EventCriteriaBuilder methods found with the same parameter type: %s".formatted(((List)list.getValue()).stream().map(wv -> ReflectionUtils.toDiscernibleSignature((Executable)wv.getMethod())).sorted().collect(Collectors.joining(", "))));
        });
        this.builderMap = eventCriteriaBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> (WrappedEventCriteriaBuilderMethod)((List)m.getValue()).getFirst()));
    }

    @Override
    @Nonnull
    public EventCriteria resolve(@Nonnull Object id, @Nonnull ProcessingContext context) {
        Optional<Object> builderResult = this.builderMap.keySet().stream().filter(c -> c.isInstance(id)).findFirst().map(this.builderMap::get).map(m -> m.resolve(id));
        if (builderResult.isPresent()) {
            return (EventCriteria)builderResult.get();
        }
        String key = Objects.requireNonNullElseGet(this.tagKey, this.entityType::getSimpleName);
        return EventCriteria.havingTags((Tag[])new Tag[]{Tag.of((String)key, (String)id.toString())});
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("idType", this.idType.getName());
        descriptor.describeProperty("entityType", this.entityType.getName());
        descriptor.describeProperty("tagKey", this.tagKey);
        descriptor.describeProperty("criteriaBuilders", this.builderMap);
    }

    private class WrappedEventCriteriaBuilderMethod {
        private final Method method;
        private final Class<?> identifierType;
        private final Object[] optionalArgumentSuppliers;

        private WrappedEventCriteriaBuilderMethod(AnnotationBasedEventCriteriaResolver annotationBasedEventCriteriaResolver, Method method) {
            if (!EventCriteria.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method annotated with @EventCriteriaBuilder must return an EventCriteria. Violating method: %s".formatted(ReflectionUtils.toDiscernibleSignature((Executable)method)));
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method annotated with @EventCriteriaBuilder must be static. Violating method: %s".formatted(ReflectionUtils.toDiscernibleSignature((Executable)method)));
            }
            if (method.getParameterCount() == 0) {
                throw new IllegalArgumentException("Method annotated with @EventCriteriaBuilder must have at least one parameter which is the identifier. Violating method: %s".formatted(ReflectionUtils.toDiscernibleSignature((Executable)method)));
            }
            this.method = (Method)ReflectionUtils.ensureAccessible((AccessibleObject)method);
            this.identifierType = method.getParameterTypes()[0];
            int optionalParameterCount = method.getParameterCount() - 1;
            this.optionalArgumentSuppliers = new Object[optionalParameterCount];
            for (int i = 0; i < optionalParameterCount; ++i) {
                Class<?> parameterType = method.getParameterTypes()[i + 1];
                if (parameterType == Configuration.class) {
                    this.optionalArgumentSuppliers[i] = annotationBasedEventCriteriaResolver.configuration;
                    continue;
                }
                Optional component = annotationBasedEventCriteriaResolver.configuration.getOptionalComponent(parameterType);
                if (component.isEmpty()) {
                    throw new IllegalArgumentException("Method annotated with @EventCriteriaBuilder declared a parameter which is not a component: %s. Violating method: %s".formatted(parameterType.getName(), ReflectionUtils.toDiscernibleSignature((Executable)method)));
                }
                this.optionalArgumentSuppliers[i] = component.get();
            }
        }

        private Object resolve(Object id) {
            Object[] args = new Object[this.method.getParameterCount()];
            args[0] = id;
            System.arraycopy(this.optionalArgumentSuppliers, 0, args, 1, this.optionalArgumentSuppliers.length);
            try {
                Object result = this.method.invoke(null, args);
                if (!(result instanceof EventCriteria)) {
                    throw new IllegalArgumentException("The @EventCriteriaBuilder method returned null. The method must return a non-null EventCriteria. Violating method: %s".formatted(ReflectionUtils.toDiscernibleSignature((Executable)this.method)));
                }
                return result;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Error invoking EventCriteriaBuilder method", e);
            }
        }

        public Class<?> getIdentifierType() {
            return this.identifierType;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

