/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AbstractSnapshotter;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotterSpanFactory;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.command.ApplyMore;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;

public class AggregateSnapshotter
extends AbstractSnapshotter {
    private final Map<Class<?>, AggregateFactory<?>> aggregateFactories;
    private final RepositoryProvider repositoryProvider;
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;
    private final MessageTypeResolver messageTypeResolver;
    private final Map<Class<?>, AggregateModel<?>> aggregateModels = new ConcurrentHashMap();

    protected AggregateSnapshotter(Builder builder) {
        super(builder);
        this.aggregateFactories = new ConcurrentHashMap(builder.aggregateFactories);
        this.repositoryProvider = builder.repositoryProvider;
        this.parameterResolverFactory = builder.buildParameterResolverFactory();
        this.handlerDefinition = builder.buildHandlerDefinition();
        this.messageTypeResolver = builder.messageTypeResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected DomainEventMessage<?> createSnapshot(Class<?> aggregateType, String aggregateIdentifier, DomainEventStream eventStream) {
        DomainEventMessage<?> firstEvent = eventStream.peek();
        AggregateFactory<?> aggregateFactory = this.getAggregateFactory(aggregateType);
        if (aggregateFactory == null) {
            throw new IllegalArgumentException("Aggregate Type is unknown in this snapshotter: " + aggregateType.getName());
        }
        this.aggregateModels.computeIfAbsent(aggregateType, k -> AnnotatedAggregateMetaModelFactory.inspectAggregate((Class)k, (ParameterResolverFactory)this.parameterResolverFactory, (HandlerDefinition)this.handlerDefinition));
        Object aggregateRoot = aggregateFactory.createAggregateRoot(aggregateIdentifier, firstEvent);
        SnapshotAggregate aggregate = new SnapshotAggregate(aggregateRoot, this.aggregateModels.get(aggregateType), this.repositoryProvider);
        aggregate.initializeState(eventStream);
        if (aggregate.isDeleted()) {
            return null;
        }
        return new GenericDomainEventMessage(aggregate.type(), aggregate.identifierAsString(), aggregate.version().longValue(), this.messageTypeResolver.resolveOrThrow(aggregateType), aggregate.getAggregateRoot());
    }

    protected AggregateFactory<?> getAggregateFactory(Class<?> aggregateType) {
        return this.aggregateFactories.get(aggregateType);
    }

    protected void registerAggregateFactory(AggregateFactory<?> aggregateFactory) {
        this.aggregateFactories.put(aggregateFactory.getAggregateType(), aggregateFactory);
    }

    public static class Builder
    extends AbstractSnapshotter.Builder {
        private final Map<Class<?>, AggregateFactory<?>> aggregateFactories = new ConcurrentHashMap();
        private RepositoryProvider repositoryProvider;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        @Override
        public Builder spanFactory(@Nonnull SnapshotterSpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        @Override
        public Builder eventStore(LegacyEventStore eventStore) {
            super.eventStore(eventStore);
            return this;
        }

        @Override
        public Builder executor(Executor executor) {
            super.executor(executor);
            return this;
        }

        @Override
        public Builder transactionManager(TransactionManager transactionManager) {
            super.transactionManager(transactionManager);
            return this;
        }

        public Builder aggregateFactories(AggregateFactory<?> ... aggregateFactories) {
            return this.aggregateFactories(Arrays.asList(aggregateFactories));
        }

        public Builder aggregateFactories(List<AggregateFactory<?>> aggregateFactories) {
            BuilderUtils.assertNonNull(aggregateFactories, (String)"AggregateFactories may not be null");
            aggregateFactories.forEach(f -> this.aggregateFactories.put(f.getAggregateType(), (AggregateFactory<?>)f));
            return this;
        }

        public Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        public Builder parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull((Object)messageTypeResolver, (String)"MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        public AggregateSnapshotter build() {
            return new AggregateSnapshotter(this);
        }

        protected ParameterResolverFactory buildParameterResolverFactory() {
            if (this.parameterResolverFactory == null) {
                this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(this.aggregateFactories.isEmpty() ? AggregateSnapshotter.class : this.aggregateFactories.values().iterator().next().getClass());
            }
            return this.parameterResolverFactory;
        }

        protected HandlerDefinition buildHandlerDefinition() {
            if (this.handlerDefinition == null) {
                this.handlerDefinition = ClasspathHandlerDefinition.forClass(this.aggregateFactories.isEmpty() ? AggregateSnapshotter.class : this.aggregateFactories.values().iterator().next().getClass());
            }
            return this.handlerDefinition;
        }

        @Override
        protected void validate() throws AxonConfigurationException {
            super.validate();
        }
    }

    private static class SnapshotAggregate<T>
    extends EventSourcedAggregate<T> {
        private SnapshotAggregate(T aggregateRoot, AggregateModel<T> aggregateModel, RepositoryProvider repositoryProvider) {
            super(aggregateRoot, aggregateModel, null, repositoryProvider, NoSnapshotTriggerDefinition.TRIGGER);
        }

        public Object handle(@Nonnull Message<?> message, @Nonnull ProcessingContext context) {
            throw new UnsupportedOperationException("Aggregate instance is read-only");
        }

        @Override
        public <P> ApplyMore doApply(P payload, MetaData metaData) {
            return this;
        }

        public ApplyMore andThen(Runnable runnable) {
            return this;
        }

        public ApplyMore andThenApply(Supplier<?> payloadOrMessageSupplier) {
            return this;
        }
    }
}

