/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventhandling.TrackedDomainEventData;
import org.axonframework.eventhandling.TrackingToken;

record LegacyJpaEventStorageOperations(TransactionManager transactionManager, EntityManagerProvider entityManagerProvider, String domainEventEntryEntityName, String snapshotEventEntryEntityName) {
    List<Object[]> fetchEvents(GapAwareTrackingToken token, int batchSize) {
        TypedQuery query = token == null || token.getGaps().isEmpty() ? this.entityManager().createQuery("SELECT e.globalIndex, e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex > :token ORDER BY e.globalIndex ASC", Object[].class) : this.entityManager().createQuery("SELECT e.globalIndex, e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex > :token OR e.globalIndex IN :gaps ORDER BY e.globalIndex ASC", Object[].class).setParameter("gaps", (Object)token.getGaps());
        return query.setParameter("token", (Object)(token == null ? -1L : token.getIndex())).setMaxResults(batchSize).getResultList();
    }

    List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return this.entityManager().createQuery("SELECT new org.axonframework.eventhandling.GenericDomainEventEntry(e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.domainEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :id AND e.sequenceNumber >= :seq ORDER BY e.sequenceNumber ASC").setParameter("id", (Object)aggregateIdentifier).setParameter("seq", (Object)firstSequenceNumber).setMaxResults(batchSize).getResultList();
    }

    List<TrackedDomainEventData<?>> entriesToEvents(GapAwareTrackingToken previousToken, List<Object[]> entries, Instant gapTimeoutThreshold, long lowestGlobalSequence, int maxGapOffset) {
        ArrayList result = new ArrayList();
        GapAwareTrackingToken token = previousToken;
        for (Object[] entry : entries) {
            long globalSequence = (Long)entry[0];
            String aggregateIdentifier = (String)entry[2];
            String eventIdentifier = (String)entry[4];
            GenericDomainEventEntry domainEvent = new GenericDomainEventEntry((String)entry[1], eventIdentifier.equals(aggregateIdentifier) ? null : aggregateIdentifier, ((Long)entry[3]).longValue(), eventIdentifier, entry[5], (String)entry[6], (String)entry[7], entry[8], entry[9]);
            boolean allowGaps = domainEvent.getTimestamp().isAfter(gapTimeoutThreshold);
            token = token == null ? GapAwareTrackingToken.newInstance((long)globalSequence, allowGaps ? (Collection)LongStream.range(Math.min(lowestGlobalSequence, globalSequence), globalSequence).boxed().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet()) : token.advanceTo(globalSequence, allowGaps ? maxGapOffset : 0);
            result.add(new TrackedDomainEventData((TrackingToken)token, (DomainEventData)domainEvent));
        }
        return result;
    }

    List<Object[]> indexAndTimestampBetweenGaps(GapAwareTrackingToken token) {
        return this.entityManager().createQuery("SELECT e.globalIndex, e.timeStamp FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex >= :firstGapOffset AND e.globalIndex <= :maxGlobalIndex", Object[].class).setParameter("firstGapOffset", token.getGaps().first()).setParameter("maxGlobalIndex", (Object)((Long)token.getGaps().last() + 1L)).getResultList();
    }

    List<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return this.entityManager().createQuery("SELECT new org.axonframework.eventhandling.GenericDomainEventEntry(e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.snapshotEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :id ORDER BY e.sequenceNumber DESC").setParameter("id", (Object)aggregateIdentifier).setMaxResults(1).getResultList();
    }

    Optional<Long> maxGlobalIndex() {
        List results = this.entityManager().createQuery("SELECT MAX(e.globalIndex) FROM " + this.domainEventEntryEntityName() + " e", Long.class).getResultList();
        return results.isEmpty() || results.getFirst() == null ? Optional.empty() : Optional.of((Long)results.getFirst());
    }

    Optional<Long> globalIndexAt(Instant dateTime) {
        List results = this.entityManager().createQuery("SELECT MIN(e.globalIndex) - 1 FROM " + this.domainEventEntryEntityName() + " e WHERE e.timeStamp >= :dateTime", Long.class).setParameter("dateTime", (Object)DateTimeUtils.formatInstant((TemporalAccessor)dateTime)).getResultList();
        return results.isEmpty() || results.getFirst() == null ? Optional.empty() : Optional.of((Long)results.getFirst());
    }

    Optional<Long> minGlobalIndex() {
        List results = this.entityManager().createQuery("SELECT MIN(e.globalIndex) - 1 FROM " + this.domainEventEntryEntityName() + " e", Long.class).getResultList();
        return results.isEmpty() || results.getFirst() == null ? Optional.empty() : Optional.of((Long)results.getFirst());
    }

    void deleteSnapshots(String aggregateIdentifier, long sequenceNumber) {
        this.entityManager().createQuery("DELETE FROM " + this.snapshotEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :aggregateIdentifier AND e.sequenceNumber < :sequenceNumber").setParameter("aggregateIdentifier", (Object)aggregateIdentifier).setParameter("sequenceNumber", (Object)sequenceNumber).executeUpdate();
    }

    Optional<Long> lastSequenceNumberFor(@Nonnull String aggregateIdentifier) {
        List results = this.entityManager().createQuery("SELECT MAX(e.sequenceNumber) FROM " + this.domainEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :aggregateId", Long.class).setParameter("aggregateId", (Object)aggregateIdentifier).getResultList();
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Long)results.get(0));
    }

    private EntityManager entityManager() {
        return this.entityManagerProvider.getEntityManager();
    }
}

