/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.slf4j.Logger;

record GapAwareTrackingTokenOperations(int gapTimeout, Logger logger) {
    GapAwareTrackingToken withGapsCleaned(GapAwareTrackingToken token, List<Object[]> indexAndTimestampBetweenGaps) {
        Instant gapTimeoutThreshold = this.gapTimeoutThreshold();
        GapAwareTrackingToken cleanedToken = token;
        for (Object[] existingEvent : indexAndTimestampBetweenGaps) {
            try {
                Instant timestamp = DateTimeUtils.parseInstant((CharSequence)existingEvent[1].toString());
                long sequenceNumber = (Long)existingEvent[0];
                boolean gapFilled = cleanedToken.getGaps().contains(sequenceNumber);
                if (gapFilled || timestamp.isAfter(gapTimeoutThreshold)) {
                    return cleanedToken;
                }
                boolean gapRightBeforeTheEvent = cleanedToken.getGaps().contains(sequenceNumber - 1L);
                if (!gapRightBeforeTheEvent) continue;
                cleanedToken = cleanedToken.withGapsTruncatedAt(sequenceNumber);
            }
            catch (DateTimeParseException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Unable to parse timestamp ('{}') to clean old gaps. Trying to proceed. ", (Object)e.getParsedString(), (Object)e);
                    continue;
                }
                this.logger.info("Unable to parse timestamp ('{}') to clean old gaps. Trying to proceed. Exception message: {}. (enable debug logging for full stack trace)", (Object)e.getParsedString(), (Object)e.getMessage());
            }
        }
        return cleanedToken;
    }

    GapAwareTrackingToken assertGapAwareTrackingToken(TrackingToken trackingToken) {
        if (trackingToken instanceof GapAwareTrackingToken) {
            GapAwareTrackingToken gapAwareTrackingToken = (GapAwareTrackingToken)trackingToken;
            return gapAwareTrackingToken;
        }
        throw new IllegalArgumentException("Tracking Token is not of expected type. Must be GapAwareTrackingToken. Is: " + trackingToken.getClass().getName());
    }

    Instant gapTimeoutThreshold() {
        return GenericEventMessage.clock.instant().minus(this.gapTimeout, ChronoUnit.MILLIS);
    }
}

