/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DefaultEventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventstreaming.StreamableEventSource;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;

public class SimpleEventStore
implements EventStore,
StreamableEventSource<EventMessage<?>> {
    private final EventStorageEngine eventStorageEngine;
    private final TagResolver tagResolver;
    private final UnitOfWorkFactory unitOfWorkFactory;
    private final Context.ResourceKey<EventStoreTransaction> eventStoreTransactionKey;

    public SimpleEventStore(@Nonnull EventStorageEngine eventStorageEngine, @Nonnull TagResolver tagResolver) {
        this.eventStorageEngine = eventStorageEngine;
        this.tagResolver = tagResolver;
        this.unitOfWorkFactory = new SimpleUnitOfWorkFactory();
        this.eventStoreTransactionKey = Context.ResourceKey.withLabel((String)"eventStoreTransaction");
    }

    @Override
    public EventStoreTransaction transaction(@Nonnull ProcessingContext processingContext) {
        return (EventStoreTransaction)processingContext.computeResourceIfAbsent(this.eventStoreTransactionKey, () -> new DefaultEventStoreTransaction(this.eventStorageEngine, processingContext, this.tagResolver));
    }

    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage<?>> events) {
        if (context == null) {
            UnitOfWork unitOfWork = this.unitOfWorkFactory.create();
            unitOfWork.runOnPostInvocation(c -> this.appendToTransaction((ProcessingContext)c, events));
            return unitOfWork.execute();
        }
        this.appendToTransaction(context, events);
        return FutureUtils.emptyCompletedFuture();
    }

    private void appendToTransaction(ProcessingContext context, List<EventMessage<?>> events) {
        EventStoreTransaction transaction = this.transaction(context);
        for (EventMessage<?> event : events) {
            transaction.appendEvent(event);
        }
    }

    public MessageStream<EventMessage<?>> open(@Nonnull StreamingCondition condition) {
        return this.eventStorageEngine.stream(condition);
    }

    public CompletableFuture<TrackingToken> firstToken() {
        return this.eventStorageEngine.firstToken();
    }

    public CompletableFuture<TrackingToken> latestToken() {
        return this.eventStorageEngine.latestToken();
    }

    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant at) {
        return this.eventStorageEngine.tokenAt(at);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("eventStorageEngine", (Object)this.eventStorageEngine);
    }
}

