/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventstreaming.Tag;

public class PayloadBasedTagResolver<P>
implements TagResolver {
    private final Class<P> payloadType;
    private final List<Function<P, Tag>> resolvers;

    private PayloadBasedTagResolver(Class<P> payloadType, List<Function<P, Tag>> resolvers) {
        this.payloadType = payloadType;
        this.resolvers = List.copyOf(resolvers);
    }

    public static <P> PayloadBasedTagResolver<P> forPayloadType(Class<P> payloadType) {
        return new PayloadBasedTagResolver<P>(payloadType, new ArrayList<Function<P, Tag>>());
    }

    public PayloadBasedTagResolver<P> withResolver(@Nonnull Function<P, Tag> resolver) {
        ArrayList<Function<P, Tag>> copy = new ArrayList<Function<P, Tag>>(this.resolvers);
        copy.add(Objects.requireNonNull(resolver, "A TagResolver cannot be null"));
        return new PayloadBasedTagResolver<P>(this.payloadType, copy);
    }

    public PayloadBasedTagResolver<P> withResolver(@Nonnull Function<P, String> keyResolver, @Nonnull Function<P, String> valueResolver) {
        Function keyLambda = Objects.requireNonNull(keyResolver, "A key resolver cannot be null");
        Function valueLambda = Objects.requireNonNull(valueResolver, "A valueLambda resolver cannot be null");
        return this.withResolver(event -> new Tag((String)keyLambda.apply(event), (String)valueLambda.apply(event)));
    }

    @Override
    public Set<Tag> resolve(@Nonnull EventMessage<?> event) {
        return this.payloadType.isAssignableFrom(event.getPayload().getClass()) ? this.resolvers.stream().map(resolver -> (Tag)resolver.apply(event.getPayload())).collect(Collectors.toSet()) : Set.of();
    }
}

