/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.GenericTaggedEventMessage;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.eventstreaming.Tag;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DefaultEventStoreTransaction
implements EventStoreTransaction {
    private final EventStorageEngine eventStorageEngine;
    private final ProcessingContext processingContext;
    private final TagResolver tagResolver;
    private final List<Consumer<EventMessage<?>>> callbacks;
    private final Context.ResourceKey<AppendCondition> appendConditionKey;
    private final Context.ResourceKey<List<TaggedEventMessage<?>>> eventQueueKey;
    private final Context.ResourceKey<ConsistencyMarker> appendPositionKey;

    public DefaultEventStoreTransaction(@Nonnull EventStorageEngine eventStorageEngine, @Nonnull ProcessingContext processingContext, @Nonnull TagResolver tagResolver) {
        this.eventStorageEngine = eventStorageEngine;
        this.processingContext = processingContext;
        this.tagResolver = tagResolver;
        this.callbacks = new CopyOnWriteArrayList();
        this.appendConditionKey = Context.ResourceKey.withLabel((String)"appendCondition");
        this.eventQueueKey = Context.ResourceKey.withLabel((String)"eventQueue");
        this.appendPositionKey = Context.ResourceKey.withLabel((String)"appendPosition");
    }

    @Override
    public MessageStream<? extends EventMessage<?>> source(@Nonnull SourcingCondition condition) {
        AppendCondition appendCondition = (AppendCondition)this.processingContext.updateResource(this.appendConditionKey, ac -> ac == null ? AppendCondition.withCriteria(condition.criteria()) : ac.orCriteria(condition.criteria()));
        MessageStream<EventMessage<?>> source = this.eventStorageEngine.source(condition);
        if (appendCondition.consistencyMarker() != ConsistencyMarker.ORIGIN) {
            return source;
        }
        AtomicReference<ConsistencyMarker> markerReference = new AtomicReference<ConsistencyMarker>(appendCondition.consistencyMarker());
        return source.onNext(entry -> {
            ConsistencyMarker marker = (ConsistencyMarker)entry.getResource(ConsistencyMarker.RESOURCE_KEY);
            if (marker != null) {
                markerReference.set(marker);
            }
        }).filter(entry -> entry.getResource(ConsistencyMarker.RESOURCE_KEY) == null).whenComplete(() -> this.updateAppendPosition(markerReference));
    }

    private void updateAppendPosition(AtomicReference<ConsistencyMarker> markerReference) {
        this.processingContext.updateResource(this.appendPositionKey, current -> {
            if (current == null || current == ConsistencyMarker.ORIGIN) {
                return (ConsistencyMarker)markerReference.get();
            }
            return current.lowerBound((ConsistencyMarker)markerReference.get());
        });
    }

    @Override
    public void appendEvent(@Nonnull EventMessage<?> eventMessage) {
        List eventQueue = (List)this.processingContext.computeResourceIfAbsent(this.eventQueueKey, () -> {
            this.attachAppendEventsStep();
            return new CopyOnWriteArrayList();
        });
        Set<Tag> tags = this.tagResolver.resolve(eventMessage);
        eventQueue.add(new GenericTaggedEventMessage(eventMessage, tags));
        this.callbacks.forEach(callback -> callback.accept(eventMessage));
    }

    private void attachAppendEventsStep() {
        this.processingContext.onPrepareCommit(context -> {
            AppendCondition appendCondition = (AppendCondition)context.updateResource(this.appendConditionKey, current -> {
                if (current == null || AppendCondition.none().equals(current)) {
                    return AppendCondition.none();
                }
                return current.withMarker((ConsistencyMarker)ObjectUtils.getOrDefault((Object)((ConsistencyMarker)context.getResource(this.appendPositionKey)), (Object)current.consistencyMarker()));
            });
            List eventQueue = (List)context.getResource(this.eventQueueKey);
            return this.eventStorageEngine.appendEvents(appendCondition, eventQueue).thenAccept(tx -> {
                this.processingContext.onCommit(c -> this.doCommit((ProcessingContext)context, (EventStorageEngine.AppendTransaction)tx));
                this.processingContext.onError((ctx, p, e) -> tx.rollback());
            });
        });
    }

    private CompletableFuture<ConsistencyMarker> doCommit(ProcessingContext commitContext, EventStorageEngine.AppendTransaction tx) {
        return tx.commit().whenComplete((position, exception) -> {
            if (position != null) {
                commitContext.updateResource(this.appendPositionKey, other -> position.upperBound(Objects.requireNonNullElse(other, ConsistencyMarker.ORIGIN)));
            }
        });
    }

    @Override
    public void onAppend(@Nonnull Consumer<EventMessage<?>> callback) {
        this.callbacks.add(callback);
    }

    @Override
    public ConsistencyMarker appendPosition() {
        return (ConsistencyMarker)ObjectUtils.getOrDefault((Object)((ConsistencyMarker)this.processingContext.getResource(this.appendPositionKey)), (Object)ConsistencyMarker.ORIGIN);
    }
}

