/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.MessagingConfigurer;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.configuration.EventSourcingConfigurationDefaults;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.modelling.configuration.ModellingConfigurer;
import org.axonframework.modelling.configuration.StatefulCommandHandlingModule;

public class EventSourcingConfigurer
implements ApplicationConfigurer {
    private final ModellingConfigurer delegate;

    public static EventSourcingConfigurer create() {
        return EventSourcingConfigurer.enhance(ModellingConfigurer.create());
    }

    public static EventSourcingConfigurer enhance(@Nonnull ModellingConfigurer modellingConfigurer) {
        return new EventSourcingConfigurer(modellingConfigurer).componentRegistry(cr -> cr.registerEnhancer((ConfigurationEnhancer)new EventSourcingConfigurationDefaults()));
    }

    public EventSourcingConfigurer(@Nonnull ModellingConfigurer delegate) {
        Objects.requireNonNull(delegate, "The delegate ModellingConfigurer may not be null.");
        this.delegate = delegate;
    }

    public EventSourcingConfigurer registerStatefulCommandHandlingModule(ModuleBuilder<StatefulCommandHandlingModule> moduleBuilder) {
        return this.modelling(modellingConfigurer -> modellingConfigurer.registerStatefulCommandHandlingModule(moduleBuilder));
    }

    public EventSourcingConfigurer registerTagResolver(@Nonnull ComponentBuilder<TagResolver> tagResolverFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(TagResolver.class, tagResolverFactory));
        return this;
    }

    public EventSourcingConfigurer registerEventStorageEngine(@Nonnull ComponentBuilder<EventStorageEngine> eventStorageEngineFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(EventStorageEngine.class, eventStorageEngineFactory));
        return this;
    }

    public EventSourcingConfigurer registerEventStore(@Nonnull ComponentBuilder<EventStore> eventStoreFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(EventStore.class, eventStoreFactory));
        return this;
    }

    public EventSourcingConfigurer registerSnapshotter(@Nonnull ComponentBuilder<Snapshotter> snapshotterFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(Snapshotter.class, snapshotterFactory));
        return this;
    }

    public EventSourcingConfigurer modelling(@Nonnull Consumer<ModellingConfigurer> configurerTask) {
        configurerTask.accept(this.delegate);
        return this;
    }

    public EventSourcingConfigurer messaging(@Nonnull Consumer<MessagingConfigurer> configurerTask) {
        this.delegate.messaging(configurerTask);
        return this;
    }

    public EventSourcingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        this.delegate.componentRegistry(componentRegistrar);
        return this;
    }

    public EventSourcingConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        this.delegate.lifecycleRegistry(lifecycleRegistrar);
        return this;
    }

    public AxonConfiguration build() {
        return this.delegate.build();
    }
}

