/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.AnnotationBasedTagResolver;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.SimpleEventStore;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;

public class EventSourcingConfigurationDefaults
implements ConfigurationEnhancer {
    public int order() {
        return 0x7FFFFFF5;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(TagResolver.class, EventSourcingConfigurationDefaults::defaultTagResolver).registerIfNotPresent(EventStorageEngine.class, EventSourcingConfigurationDefaults::defaultEventStorageEngine).registerIfNotPresent(EventStore.class, EventSourcingConfigurationDefaults::defaultEventStore).registerIfNotPresent(Snapshotter.class, EventSourcingConfigurationDefaults::defaultSnapshotter);
    }

    private static TagResolver defaultTagResolver(Configuration configuration) {
        return new AnnotationBasedTagResolver();
    }

    private static EventStorageEngine defaultEventStorageEngine(Configuration config) {
        return new InMemoryEventStorageEngine();
    }

    private static EventStore defaultEventStore(Configuration config) {
        return new SimpleEventStore((EventStorageEngine)config.getComponent(EventStorageEngine.class), (TagResolver)config.getComponent(TagResolver.class));
    }

    private static EventSink defaultEventSink(Configuration config) {
        return (EventSink)config.getComponent(EventStore.class);
    }

    private static Snapshotter defaultSnapshotter(Configuration config) {
        return (aggregateType, aggregateIdentifier) -> {};
    }
}

