/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import jakarta.persistence.EntityManager;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.LegacyBatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jpa.DomainEventEntry;
import org.axonframework.eventsourcing.eventstore.jpa.GapAwareTrackingTokenOperations;
import org.axonframework.eventsourcing.eventstore.jpa.LegacyJpaEventStorageOperations;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jpa.SnapshotEventEntry;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="5.0.0")
public class LegacyJpaEventStorageEngine
extends LegacyBatchingEventStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(LegacyJpaEventStorageEngine.class);
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private final EntityManagerProvider entityManagerProvider;
    private final TransactionManager transactionManager;
    private final boolean explicitFlush;
    private final int maxGapOffset;
    private final long lowestGlobalSequence;
    private int gapTimeout;
    private int gapCleaningThreshold;
    private final LegacyJpaEventStorageOperations legacyJpaOperations;
    private final GapAwareTrackingTokenOperations tokenOperations;

    protected LegacyJpaEventStorageEngine(Builder builder) {
        super(builder);
        this.entityManagerProvider = builder.entityManagerProvider;
        this.transactionManager = builder.transactionManager;
        this.explicitFlush = builder.explicitFlush;
        this.maxGapOffset = builder.maxGapOffset;
        this.lowestGlobalSequence = builder.lowestGlobalSequence;
        this.gapTimeout = builder.gapTimeout;
        this.gapCleaningThreshold = builder.gapCleaningThreshold;
        this.legacyJpaOperations = new LegacyJpaEventStorageOperations(this.transactionManager, this.entityManagerProvider, this.domainEventEntryEntityName(), this.snapshotEventEntryEntityName());
        this.tokenOperations = new GapAwareTrackingTokenOperations(this.gapTimeout, logger);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static <T> DomainEventMessage<T> asDomainEventMessage(EventMessage<T> event) {
        return event instanceof DomainEventMessage ? (DomainEventMessage)event : new GenericDomainEventMessage(null, event.getIdentifier(), 0L, event, () -> event.getTimestamp());
    }

    protected List<Object[]> fetchEvents(GapAwareTrackingToken token) {
        return this.legacyJpaOperations.fetchEvents(token, this.batchSize());
    }

    @Override
    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        Assert.isTrue((lastToken == null || lastToken instanceof GapAwareTrackingToken ? 1 : 0) != 0, () -> String.format("Token [%s] is of the wrong type. Expected [%s]", lastToken, GapAwareTrackingToken.class.getSimpleName()));
        GapAwareTrackingToken previousToken = this.cleanedToken((GapAwareTrackingToken)lastToken);
        List entries = (List)this.transactionManager.fetchInTransaction(() -> this.fetchEvents(previousToken));
        return this.legacyJpaOperations.entriesToEvents(previousToken, entries, this.tokenOperations.gapTimeoutThreshold(), this.lowestGlobalSequence, this.maxGapOffset);
    }

    private GapAwareTrackingToken cleanedToken(GapAwareTrackingToken lastToken) {
        if (lastToken != null && lastToken.getGaps().size() > this.gapCleaningThreshold) {
            return this.tokenOperations.withGapsCleaned(lastToken, this.indexToTimestamp(lastToken));
        }
        return lastToken;
    }

    private List<Object[]> indexToTimestamp(GapAwareTrackingToken lastToken) {
        return (List)this.transactionManager.fetchInTransaction(() -> this.legacyJpaOperations.indexAndTimestampBetweenGaps(lastToken));
    }

    @Override
    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return (List)this.transactionManager.fetchInTransaction(() -> this.legacyJpaOperations.fetchDomainEvents(aggregateIdentifier, firstSequenceNumber, batchSize));
    }

    @Override
    protected Stream<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return (Stream)this.transactionManager.fetchInTransaction(() -> this.legacyJpaOperations.readSnapshotData(aggregateIdentifier).stream());
    }

    @Override
    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (events.isEmpty()) {
            return;
        }
        this.transactionManager.executeInTransaction(() -> {
            try {
                events.stream().map(event -> this.createEventEntity((EventMessage<?>)event, serializer)).forEach(arg_0 -> ((EntityManager)this.entityManager()).persist(arg_0));
                if (this.explicitFlush) {
                    this.entityManager().flush();
                }
            }
            catch (Exception e) {
                this.handlePersistenceException(e, (EventMessage)events.get(0));
            }
        });
    }

    @Override
    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        try {
            this.entityManager().merge(this.createSnapshotEntity(snapshot, serializer));
            this.deleteSnapshots(snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber());
            if (this.explicitFlush) {
                this.entityManager().flush();
            }
        }
        catch (Exception e) {
            this.handlePersistenceException(e, (EventMessage<?>)snapshot);
        }
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(@Nonnull String aggregateIdentifier) {
        return this.legacyJpaOperations.lastSequenceNumberFor(aggregateIdentifier);
    }

    @Override
    public TrackingToken createTailToken() {
        return this.legacyJpaOperations.minGlobalIndex().flatMap(this::gapAwareTrackingTokenOn).orElse(null);
    }

    @Override
    public TrackingToken createHeadToken() {
        return this.legacyJpaOperations.maxGlobalIndex().flatMap(this::gapAwareTrackingTokenOn).orElse(null);
    }

    @Override
    public TrackingToken createTokenAt(@Nonnull Instant dateTime) {
        return this.legacyJpaOperations.globalIndexAt(dateTime).flatMap(this::gapAwareTrackingTokenOn).or(() -> this.legacyJpaOperations.maxGlobalIndex().flatMap(this::gapAwareTrackingTokenOn)).orElse(null);
    }

    private Optional<TrackingToken> gapAwareTrackingTokenOn(Long globalIndex) {
        return globalIndex == null ? Optional.empty() : Optional.of(GapAwareTrackingToken.newInstance((long)globalIndex, Collections.emptySet()));
    }

    protected void deleteSnapshots(String aggregateIdentifier, long sequenceNumber) {
        this.legacyJpaOperations.deleteSnapshots(aggregateIdentifier, sequenceNumber);
    }

    protected Object createEventEntity(EventMessage<?> eventMessage, Serializer serializer) {
        return new DomainEventEntry(LegacyJpaEventStorageEngine.asDomainEventMessage(eventMessage), serializer);
    }

    protected Object createSnapshotEntity(DomainEventMessage<?> snapshot, Serializer serializer) {
        return new SnapshotEventEntry(snapshot, serializer);
    }

    protected String domainEventEntryEntityName() {
        return DomainEventEntry.class.getSimpleName();
    }

    protected String snapshotEventEntryEntityName() {
        return SnapshotEventEntry.class.getSimpleName();
    }

    protected EntityManager entityManager() {
        return this.entityManagerProvider.getEntityManager();
    }

    public void setGapTimeout(int gapTimeout) {
        this.gapTimeout = gapTimeout;
    }

    public void setGapCleaningThreshold(int gapCleaningThreshold) {
        this.gapCleaningThreshold = gapCleaningThreshold;
    }

    public static class Builder
    extends LegacyBatchingEventStorageEngine.Builder {
        private EntityManagerProvider entityManagerProvider;
        private TransactionManager transactionManager;
        private boolean explicitFlush = true;
        private int maxGapOffset = 10000;
        private long lowestGlobalSequence = 1L;
        private int gapTimeout = 60000;
        private int gapCleaningThreshold = 250;

        @Override
        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            super.snapshotSerializer(snapshotSerializer);
            return this;
        }

        @Override
        public Builder upcasterChain(EventUpcaster upcasterChain) {
            super.upcasterChain(upcasterChain);
            return this;
        }

        @Override
        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            super.persistenceExceptionResolver(persistenceExceptionResolver);
            return this;
        }

        @Override
        public Builder eventSerializer(Serializer eventSerializer) {
            super.eventSerializer(eventSerializer);
            return this;
        }

        @Override
        public Builder finalAggregateBatchPredicate(Predicate<List<? extends DomainEventData<?>>> finalAggregateBatchPredicate) {
            super.finalAggregateBatchPredicate(finalAggregateBatchPredicate);
            return this;
        }

        @Override
        public Builder snapshotFilter(SnapshotFilter snapshotFilter) {
            super.snapshotFilter(snapshotFilter);
            return this;
        }

        @Override
        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        public Builder dataSource(DataSource dataSource) throws SQLException {
            this.persistenceExceptionResolver(new SQLErrorCodesResolver(dataSource));
            return this;
        }

        public Builder entityManagerProvider(EntityManagerProvider entityManagerProvider) {
            BuilderUtils.assertNonNull((Object)entityManagerProvider, (String)"EntityManagerProvider may not be null");
            this.entityManagerProvider = entityManagerProvider;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull((Object)transactionManager, (String)"TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder explicitFlush(boolean explicitFlush) {
            this.explicitFlush = explicitFlush;
            return this;
        }

        public Builder maxGapOffset(int maxGapOffset) {
            this.assertPositive(maxGapOffset, "maxGapOffset");
            this.maxGapOffset = maxGapOffset;
            return this;
        }

        public Builder lowestGlobalSequence(long lowestGlobalSequence) {
            BuilderUtils.assertThat((Object)lowestGlobalSequence, number -> number > 0L, (String)"The lowestGlobalSequence must be a positive number");
            this.lowestGlobalSequence = lowestGlobalSequence;
            return this;
        }

        public Builder gapTimeout(int gapTimeout) {
            this.assertPositive(gapTimeout, "gapTimeout");
            this.gapTimeout = gapTimeout;
            return this;
        }

        public Builder gapCleaningThreshold(int gapCleaningThreshold) {
            this.assertPositive(gapCleaningThreshold, "gapCleaningThreshold");
            this.gapCleaningThreshold = gapCleaningThreshold;
            return this;
        }

        private void assertPositive(int num, String numberDescription) {
            BuilderUtils.assertThat((Object)num, number -> number > 0, (String)("The " + numberDescription + " must be a positive number"));
        }

        public LegacyJpaEventStorageEngine build() {
            return new LegacyJpaEventStorageEngine(this);
        }

        @Override
        protected void validate() throws AxonConfigurationException {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.entityManagerProvider, (String)"The EntityManagerProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.transactionManager, (String)"The TransactionManager is a hard requirement and should be provided");
        }
    }
}

