/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.axonframework.eventsourcing.eventstore.AnyEvent;
import org.axonframework.eventsourcing.eventstore.EventCriteria;
import org.axonframework.eventsourcing.eventstore.EventCriterion;
import org.axonframework.eventsourcing.eventstore.EventTypeRestrictableEventCriteria;
import org.axonframework.eventsourcing.eventstore.OrEventCriteria;
import org.axonframework.eventsourcing.eventstore.Tag;
import org.axonframework.eventsourcing.eventstore.TagAndTypeFilteredEventCriteria;
import org.axonframework.messaging.QualifiedName;

record TagFilteredEventCriteria(@Nonnull Set<Tag> tags) implements EventCriteria,
EventCriterion,
EventTypeRestrictableEventCriteria
{
    TagFilteredEventCriteria(@Nonnull Set<Tag> tags) {
        this.tags = Set.copyOf((Collection)Objects.requireNonNull(tags, "The tags cannot be null"));
    }

    @Override
    public Set<EventCriterion> flatten() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        return Set.of(this);
    }

    @Override
    public Set<QualifiedName> types() {
        return Collections.emptySet();
    }

    @Override
    public boolean matches(@Nonnull QualifiedName type, @Nonnull Set<Tag> tags) {
        return this.matchesTags(tags);
    }

    private boolean matchesTags(Set<Tag> tags) {
        return tags.containsAll(this.tags);
    }

    @Override
    public EventCriteria or(EventCriteria criteria) {
        if (criteria instanceof AnyEvent) {
            return criteria;
        }
        if (criteria.equals(this)) {
            return this;
        }
        if (criteria instanceof OrEventCriteria) {
            OrEventCriteria orEventCriteria = (OrEventCriteria)criteria;
            return orEventCriteria.or(this);
        }
        return new OrEventCriteria(Set.of(this, criteria));
    }

    @Override
    public boolean hasCriteria() {
        return !this.tags.isEmpty();
    }

    @Override
    public EventCriteria andBeingOneOfTypes(@Nonnull Set<QualifiedName> types) {
        return new TagAndTypeFilteredEventCriteria(types, this.tags);
    }
}

