/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.axonframework.eventsourcing.eventstore.AnyEvent;
import org.axonframework.eventsourcing.eventstore.EventCriteria;
import org.axonframework.eventsourcing.eventstore.EventCriterion;
import org.axonframework.eventsourcing.eventstore.OrEventCriteria;
import org.axonframework.eventsourcing.eventstore.Tag;
import org.axonframework.messaging.QualifiedName;

record TagAndTypeFilteredEventCriteria(@Nonnull Set<QualifiedName> types, @Nonnull Set<Tag> tags) implements EventCriteria,
EventCriterion
{
    TagAndTypeFilteredEventCriteria(@Nonnull Set<QualifiedName> types, @Nonnull Set<Tag> tags) {
        this.types = Set.copyOf((Collection)Objects.requireNonNull(types, "The types cannot be null"));
        this.tags = Set.copyOf((Collection)Objects.requireNonNull(tags, "The tags cannot be null"));
    }

    @Override
    public Set<EventCriterion> flatten() {
        if (this.types.isEmpty() && this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        return Set.of(this);
    }

    @Override
    public boolean matches(@Nonnull QualifiedName type, @Nonnull Set<Tag> tags) {
        return this.matchesType(type) && this.matchesTags(tags);
    }

    private boolean matchesType(QualifiedName type) {
        return this.types.isEmpty() || this.types.contains(type);
    }

    private boolean matchesTags(Set<Tag> tags) {
        return tags.containsAll(this.tags);
    }

    @Override
    public EventCriteria or(EventCriteria criteria) {
        if (criteria instanceof AnyEvent) {
            return criteria;
        }
        if (criteria.equals(this)) {
            return this;
        }
        if (criteria instanceof OrEventCriteria) {
            OrEventCriteria orEventCriteria = (OrEventCriteria)criteria;
            return orEventCriteria.or(this);
        }
        return new OrEventCriteria(Set.of(this, criteria));
    }

    @Override
    public boolean hasCriteria() {
        return !this.tags.isEmpty() || !this.types.isEmpty();
    }
}

