/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DefaultEventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.StreamableEventSource;
import org.axonframework.eventsourcing.eventstore.StreamingCondition;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class SimpleEventStore
implements EventStore,
StreamableEventSource<EventMessage<?>> {
    private final EventStorageEngine eventStorageEngine;
    private final TagResolver tagResolver;
    private final Context.ResourceKey<EventStoreTransaction> eventStoreTransactionKey;

    public SimpleEventStore(@Nonnull EventStorageEngine eventStorageEngine, @Nonnull TagResolver tagResolver) {
        this.eventStorageEngine = eventStorageEngine;
        this.tagResolver = tagResolver;
        this.eventStoreTransactionKey = Context.ResourceKey.withLabel((String)"eventStoreTransaction");
    }

    @Override
    public EventStoreTransaction transaction(@Nonnull ProcessingContext processingContext) {
        return (EventStoreTransaction)processingContext.computeResourceIfAbsent(this.eventStoreTransactionKey, () -> new DefaultEventStoreTransaction(this.eventStorageEngine, processingContext, this.tagResolver));
    }

    @Override
    public void publish(@Nonnull ProcessingContext processingContext, @Nonnull List<EventMessage<?>> events) {
        EventStoreTransaction transaction = this.transaction(processingContext);
        for (EventMessage<?> event : events) {
            transaction.appendEvent(event);
        }
    }

    public CompletableFuture<Void> publish(@Nonnull List<EventMessage<?>> events) {
        throw new UnsupportedOperationException("Publishing events with the SimpleEventStore requires a ProcessingContext at all times.\nOr, use an EventStoreTransaction as provided by the SimpleEventStore instead.\n");
    }

    @Override
    public MessageStream<EventMessage<?>> open(@Nonnull StreamingCondition condition) {
        return this.eventStorageEngine.stream(condition);
    }

    @Override
    public CompletableFuture<TrackingToken> headToken() {
        return this.eventStorageEngine.headToken();
    }

    @Override
    public CompletableFuture<TrackingToken> tailToken() {
        return this.eventStorageEngine.tailToken();
    }

    @Override
    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant at) {
        return this.eventStorageEngine.tokenAt(at);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("eventStorageEngine", (Object)this.eventStorageEngine);
    }
}

