/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.LegacyEventStorageEngine;

@Deprecated(since="5.0.0")
public class LegacySequenceEventStorageEngine
implements LegacyEventStorageEngine {
    private final LegacyEventStorageEngine historicStorage;
    private final LegacyEventStorageEngine activeStorage;

    public LegacySequenceEventStorageEngine(LegacyEventStorageEngine historicStorage, LegacyEventStorageEngine activeStorage) {
        this.historicStorage = historicStorage;
        this.activeStorage = activeStorage;
    }

    @Override
    public void appendEvents(@Nonnull List<? extends EventMessage<?>> events) {
        this.activeStorage.appendEvents(events);
    }

    @Override
    public void storeSnapshot(@Nonnull DomainEventMessage<?> snapshot) {
        this.activeStorage.storeSnapshot(snapshot);
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        Spliterator historicSpliterator = this.historicStorage.readEvents(trackingToken, mayBlock).spliterator();
        ConcatenatingSpliterator merged = new ConcatenatingSpliterator(trackingToken, historicSpliterator, mayBlock, token -> this.activeStorage.readEvents((TrackingToken)token, mayBlock).spliterator());
        return StreamSupport.stream(merged, false);
    }

    @Override
    public DomainEventStream readEvents(@Nonnull String aggregateIdentifier, long firstSequenceNumber) {
        DomainEventStream historic = this.historicStorage.readEvents(aggregateIdentifier, firstSequenceNumber);
        return new ConcatenatingDomainEventStream(historic, aggregateIdentifier, firstSequenceNumber, (id, seq) -> this.activeStorage.readEvents(aggregateIdentifier, (long)seq));
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(@Nonnull String aggregateIdentifier) {
        Optional<DomainEventMessage<?>> optionalDomainEventMessage = this.activeStorage.readSnapshot(aggregateIdentifier);
        return optionalDomainEventMessage.isPresent() ? optionalDomainEventMessage : this.historicStorage.readSnapshot(aggregateIdentifier);
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(@Nonnull String aggregateIdentifier) {
        Optional<Long> result = this.activeStorage.lastSequenceNumberFor(aggregateIdentifier);
        if (result.isPresent()) {
            return result;
        }
        return this.historicStorage.lastSequenceNumberFor(aggregateIdentifier);
    }

    @Override
    public TrackingToken createTailToken() {
        return this.historicStorage.createTailToken();
    }

    @Override
    public TrackingToken createHeadToken() {
        return this.activeStorage.createHeadToken();
    }

    @Override
    public TrackingToken createTokenAt(@Nonnull Instant dateTime) {
        TrackingToken tokenFromActiveStorage = this.activeStorage.createTokenAt(dateTime);
        if (tokenFromActiveStorage == null) {
            return this.historicStorage.createTokenAt(dateTime);
        }
        return tokenFromActiveStorage;
    }

    private static class ConcatenatingSpliterator
    extends Spliterators.AbstractSpliterator<TrackedEventMessage<?>> {
        private final Spliterator<? extends TrackedEventMessage<?>> historicSpliterator;
        private final boolean mayBlock;
        private final Function<TrackingToken, Spliterator<? extends TrackedEventMessage<?>>> nextProvider;
        private TrackingToken lastToken;
        private Spliterator<? extends TrackedEventMessage<?>> active;

        public ConcatenatingSpliterator(TrackingToken initialToken, Spliterator<? extends TrackedEventMessage<?>> historicSpliterator, boolean mayBlock, Function<TrackingToken, Spliterator<? extends TrackedEventMessage<?>>> nextProvider) {
            super(Long.MAX_VALUE, 16);
            this.lastToken = initialToken;
            this.historicSpliterator = historicSpliterator;
            this.mayBlock = mayBlock;
            this.nextProvider = nextProvider;
        }

        @Override
        public boolean tryAdvance(Consumer<? super TrackedEventMessage<?>> action) {
            if (this.active == null && this.historicSpliterator.tryAdvance((? super T message) -> {
                this.lastToken = message.trackingToken();
                action.accept((TrackedEventMessage<?>)message);
            })) {
                return true;
            }
            if (this.active == null) {
                this.active = this.nextProvider.apply(this.lastToken);
            }
            return this.active.tryAdvance((? super T message) -> {
                this.lastToken = message.trackingToken();
                action.accept((TrackedEventMessage<?>)message);
            });
        }
    }

    private static class ConcatenatingDomainEventStream
    implements DomainEventStream {
        private final DomainEventStream historic;
        private final String aggregateIdentifier;
        private final long firstSequenceNumber;
        private final BiFunction<String, Long, DomainEventStream> domainEventStream;
        private DomainEventStream actual;

        public ConcatenatingDomainEventStream(DomainEventStream historic, String aggregateIdentifier, long firstSequenceNumber, BiFunction<String, Long, DomainEventStream> domainEventStream) {
            this.historic = historic;
            this.aggregateIdentifier = aggregateIdentifier;
            this.firstSequenceNumber = firstSequenceNumber;
            this.domainEventStream = domainEventStream;
        }

        @Override
        public boolean hasNext() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.hasNext();
            }
            return this.actual.hasNext();
        }

        private void initActiveIfRequired() {
            if (this.actual == null && !this.historic.hasNext()) {
                this.actual = this.domainEventStream.apply(this.aggregateIdentifier, this.nextSequenceNumber());
            }
        }

        private long nextSequenceNumber() {
            Long lastSequenceNumber = this.historic.getLastSequenceNumber();
            return lastSequenceNumber == null ? this.firstSequenceNumber : lastSequenceNumber + 1L;
        }

        @Override
        public DomainEventMessage<?> next() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.next();
            }
            return this.actual.next();
        }

        @Override
        public DomainEventMessage<?> peek() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.peek();
            }
            return this.actual.peek();
        }

        @Override
        public Long getLastSequenceNumber() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.getLastSequenceNumber();
            }
            Long actualLastSequenceNumber = this.actual.getLastSequenceNumber();
            return actualLastSequenceNumber != null ? actualLastSequenceNumber : this.historic.getLastSequenceNumber();
        }
    }
}

