/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.conflictresolution;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.conflictresolution.ConflictResolver;
import org.axonframework.eventsourcing.conflictresolution.ContextAwareConflictExceptionSupplier;
import org.axonframework.eventsourcing.conflictresolution.DefaultConflictDescription;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.modelling.command.ConflictingAggregateVersionException;

public class DefaultConflictResolver
implements ConflictResolver {
    private final LegacyEventStore eventStore;
    private final String aggregateIdentifier;
    private final long expectedVersion;
    private final long actualVersion;
    private List<DomainEventMessage<?>> events;
    private boolean conflictsResolved;

    public DefaultConflictResolver(LegacyEventStore eventStore, String aggregateIdentifier, long expectedVersion, long actualVersion) {
        this.eventStore = eventStore;
        this.aggregateIdentifier = aggregateIdentifier;
        this.expectedVersion = expectedVersion;
        this.actualVersion = actualVersion;
    }

    @Override
    public <T extends Exception> void detectConflicts(Predicate<List<DomainEventMessage<?>>> predicate, ContextAwareConflictExceptionSupplier<T> exceptionSupplier) throws T {
        Exception exception;
        this.conflictsResolved = true;
        List<DomainEventMessage<?>> unexpectedEvents = this.unexpectedEvents();
        if (predicate.test(unexpectedEvents) && (exception = (Exception)exceptionSupplier.supplyException(new DefaultConflictDescription(this.aggregateIdentifier, this.expectedVersion, this.actualVersion, unexpectedEvents))) != null) {
            throw exception;
        }
    }

    public void ensureConflictsResolved() {
        if (!this.conflictsResolved) {
            throw new ConflictingAggregateVersionException(this.aggregateIdentifier, this.expectedVersion, this.actualVersion);
        }
    }

    private List<DomainEventMessage<?>> unexpectedEvents() {
        if (this.events == null) {
            if (this.expectedVersion >= this.actualVersion) {
                return Collections.emptyList();
            }
            this.events = this.eventStore.readEvents(this.aggregateIdentifier, this.expectedVersion + 1L).asStream().filter(event -> event.getSequenceNumber() <= this.actualVersion).collect(Collectors.toList());
        }
        return this.events;
    }
}

