/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.function.Consumer;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.MessagingConfigurer;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.configuration.EventSourcingConfigurationDefaults;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.modelling.configuration.ModellingConfigurer;
import org.axonframework.modelling.configuration.StatefulCommandHandlingModule;

public class EventSourcingConfigurer
implements ApplicationConfigurer {
    private final ModellingConfigurer delegate;

    public static EventSourcingConfigurer create() {
        return new EventSourcingConfigurer(ModellingConfigurer.create());
    }

    public EventSourcingConfigurer(@Nonnull ModellingConfigurer delegate) {
        delegate.componentRegistry(cr -> cr.registerEnhancer((ConfigurationEnhancer)new EventSourcingConfigurationDefaults()));
        this.delegate = delegate;
    }

    public EventSourcingConfigurer registerStatefulCommandHandlingModule(ModuleBuilder<StatefulCommandHandlingModule> moduleBuilder) {
        return this.modelling(modellingConfigurer -> modellingConfigurer.registerStatefulCommandHandlingModule(moduleBuilder));
    }

    public EventSourcingConfigurer registerTagResolver(@Nonnull ComponentFactory<TagResolver> tagResolverFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(TagResolver.class, tagResolverFactory));
        return this;
    }

    public EventSourcingConfigurer registerEventStorageEngine(@Nonnull ComponentFactory<EventStorageEngine> eventStorageEngineFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(EventStorageEngine.class, eventStorageEngineFactory));
        return this;
    }

    public EventSourcingConfigurer registerEventStore(@Nonnull ComponentFactory<EventStore> eventStoreFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(EventStore.class, eventStoreFactory));
        return this;
    }

    public EventSourcingConfigurer registerSnapshotter(@Nonnull ComponentFactory<Snapshotter> snapshotterFactory) {
        this.delegate.componentRegistry(cr -> cr.registerComponent(Snapshotter.class, snapshotterFactory));
        return this;
    }

    public EventSourcingConfigurer modelling(@Nonnull Consumer<ModellingConfigurer> configurerTask) {
        configurerTask.accept(this.delegate);
        return this;
    }

    public EventSourcingConfigurer messaging(@Nonnull Consumer<MessagingConfigurer> configurerTask) {
        this.delegate.messaging(configurerTask);
        return this;
    }

    public ApplicationConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        return this.delegate.componentRegistry(componentRegistrar);
    }

    public ApplicationConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        return this.delegate.lifecycleRegistry(lifecycleRegistrar);
    }

    public AxonConfiguration build() {
        return this.delegate.build();
    }
}

