/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.AnnotationBasedTagResolver;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.SimpleEventStore;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;

class EventSourcingConfigurationDefaults
implements ConfigurationEnhancer {
    EventSourcingConfigurationDefaults() {
    }

    public int order() {
        return 0x7FFFFFFE;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        Objects.requireNonNull(registry, "Cannot enhance a null ComponentRegistry.");
        this.registerIfNotPresent(registry, TagResolver.class, EventSourcingConfigurationDefaults::defaultTagResolver);
        this.registerIfNotPresent(registry, EventStorageEngine.class, EventSourcingConfigurationDefaults::defaultEventStorageEngine);
        this.registerIfNotPresent(registry, EventStore.class, EventSourcingConfigurationDefaults::defaultEventStore);
        this.registerIfNotPresent(registry, EventSink.class, EventSourcingConfigurationDefaults::defaultEventSink);
        this.registerIfNotPresent(registry, Snapshotter.class, EventSourcingConfigurationDefaults::defaultSnapshotter);
    }

    private <C> void registerIfNotPresent(ComponentRegistry registry, Class<C> type, ComponentFactory<C> factory) {
        if (!registry.hasComponent(type)) {
            registry.registerComponent(type, factory);
        }
    }

    private static TagResolver defaultTagResolver(Configuration configuration) {
        return new AnnotationBasedTagResolver();
    }

    private static EventStorageEngine defaultEventStorageEngine(Configuration config) {
        return new InMemoryEventStorageEngine();
    }

    private static EventStore defaultEventStore(Configuration config) {
        return new SimpleEventStore((EventStorageEngine)config.getComponent(EventStorageEngine.class), (TagResolver)config.getComponent(TagResolver.class));
    }

    private static EventSink defaultEventSink(Configuration config) {
        return (EventSink)config.getComponent(EventStore.class);
    }

    private static Snapshotter defaultSnapshotter(Configuration config) {
        return (aggregateType, aggregateIdentifier) -> {};
    }
}

