/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.annotation.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.configuration.AnnotatedEventSourcedEntityBuilder;
import org.axonframework.eventsourcing.configuration.DefaultEventSourcedEntityBuilder;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.configuration.EntityBuilder;

public interface EventSourcedEntityBuilder<I, E>
extends EntityBuilder<I, E> {
    public static <I, E> EntityFactoryPhase<I, E> entity(@Nonnull Class<I> idType, @Nonnull Class<E> entityType) {
        return new DefaultEventSourcedEntityBuilder<I, E>(idType, entityType);
    }

    public static <I, E> EventSourcedEntityBuilder<I, E> annotatedEntity(@Nonnull Class<I> idType, @Nonnull Class<E> entityType) {
        return new AnnotatedEventSourcedEntityBuilder<I, E>(idType, entityType);
    }

    public static interface EventSourcingHandlerPhase<I, E>
    extends EventSourcedEntityBuilder<I, E> {
        public EventSourcedEntityBuilder<I, E> entityEvolver(@Nonnull ComponentFactory<EntityEvolver<E>> var1);

        default public <P> EventSourcingHandlerPhase<I, E> eventSourcingHandler(@Nonnull Class<P> payloadType, @Nonnull BiConsumer<E, P> eventSourcingHandler) {
            return this.eventSourcingHandler(new QualifiedName(payloadType), payloadType, eventSourcingHandler);
        }

        default public <P> EventSourcingHandlerPhase<I, E> eventSourcingHandler(@Nonnull QualifiedName eventName, @Nonnull Class<P> payloadType, @Nonnull BiConsumer<E, P> eventSourcingHandler) {
            return this.eventSourcingHandler(eventName, payloadType, (E entity, P payload) -> {
                Objects.requireNonNull(eventSourcingHandler, "The event sourcing handler must not be null.").accept(entity, payload);
                return entity;
            });
        }

        default public <P> EventSourcingHandlerPhase<I, E> eventSourcingHandler(@Nonnull Class<P> payloadType, @Nonnull BiFunction<E, P, E> eventSourcingHandler) {
            return this.eventSourcingHandler(new QualifiedName(payloadType), payloadType, eventSourcingHandler);
        }

        public <P> EventSourcingHandlerPhase<I, E> eventSourcingHandler(@Nonnull QualifiedName var1, @Nonnull Class<P> var2, @Nonnull BiFunction<E, P, E> var3);
    }

    public static interface CriteriaResolverPhase<I, E> {
        public EventSourcingHandlerPhase<I, E> criteriaResolver(@Nonnull ComponentFactory<CriteriaResolver<I>> var1);
    }

    public static interface EntityFactoryPhase<I, E> {
        public CriteriaResolverPhase<I, E> entityFactory(@Nonnull ComponentFactory<EventSourcedEntityFactory<I, E>> var1);
    }
}

