/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.SimpleEventSourcedComponent;
import org.axonframework.eventsourcing.annotation.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.configuration.EventSourcedEntityBuilder;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.PayloadBasedEntityEvolver;
import org.axonframework.modelling.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultEventSourcedEntityBuilder<I, E>
implements EventSourcedEntityBuilder<I, E>,
EventSourcedEntityBuilder.EntityFactoryPhase<I, E>,
EventSourcedEntityBuilder.CriteriaResolverPhase<I, E>,
EventSourcedEntityBuilder.EventSourcingHandlerPhase<I, E> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Class<I> idType;
    private final Class<E> entityType;
    private ComponentFactory<EventSourcedEntityFactory<I, E>> entityFactory;
    private ComponentFactory<CriteriaResolver<I>> criteriaResolver;
    private ComponentFactory<EntityEvolver<E>> entityEvolver;
    private final Map<QualifiedName, ComponentFactory<EntityEvolver<E>>> entityEvolverPerName = new HashMap<QualifiedName, ComponentFactory<EntityEvolver<E>>>();

    DefaultEventSourcedEntityBuilder(@Nonnull Class<I> idType, @Nonnull Class<E> entityType) {
        this.idType = Objects.requireNonNull(idType, "The identifier type cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type cannot be null.");
    }

    @Override
    public EventSourcedEntityBuilder.CriteriaResolverPhase<I, E> entityFactory(@Nonnull ComponentFactory<EventSourcedEntityFactory<I, E>> entityFactory) {
        this.entityFactory = Objects.requireNonNull(entityFactory, "The entity factory cannot be null.");
        return this;
    }

    @Override
    public EventSourcedEntityBuilder.EventSourcingHandlerPhase<I, E> criteriaResolver(@Nonnull ComponentFactory<CriteriaResolver<I>> criteriaResolver) {
        this.criteriaResolver = Objects.requireNonNull(criteriaResolver, "The criteria resolver cannot be null.");
        return this;
    }

    @Override
    public EventSourcedEntityBuilder<I, E> entityEvolver(@Nonnull ComponentFactory<EntityEvolver<E>> entityEvolver) {
        this.entityEvolver = Objects.requireNonNull(entityEvolver, "The event state applier cannot be null.");
        return this;
    }

    @Override
    public <P> EventSourcedEntityBuilder.EventSourcingHandlerPhase<I, E> eventSourcingHandler(@Nonnull QualifiedName eventName, @Nonnull Class<P> payloadType, @Nonnull BiFunction<E, P, E> eventSourcingHandler) {
        if (this.entityEvolverPerName.containsKey(eventName)) {
            throw new IllegalArgumentException("Event Sourcing Handler for name [" + String.valueOf(eventName) + "] already exists");
        }
        this.entityEvolverPerName.put(eventName, c -> new PayloadBasedEntityEvolver(payloadType, eventSourcingHandler));
        return this;
    }

    public String entityName() {
        return this.entityType.getSimpleName() + "#" + this.idType.getSimpleName();
    }

    public ComponentFactory<Repository<I, E>> repository() {
        return config -> new EventSourcingRepository<I, E>(this.idType, this.entityType, (EventStore)config.getComponent(EventStore.class), (EventSourcedEntityFactory)this.entityFactory.build(config), (CriteriaResolver)this.criteriaResolver.build(config), this.constructEntityEvolver(config));
    }

    private EntityEvolver<E> constructEntityEvolver(Configuration config) {
        if (this.entityEvolver != null) {
            if (this.entityEvolverPerName.size() > 1) {
                logger.warn("Ignoring separate Event Sourcing Handlers since an EntityEvolver has been given!");
            }
            return (EntityEvolver)this.entityEvolver.build(config);
        }
        return new SimpleEventSourcedComponent<E>(this.buildAndCollectEntityEvolvers(config));
    }

    private Map<QualifiedName, EntityEvolver<E>> buildAndCollectEntityEvolvers(Configuration config) {
        return this.entityEvolverPerName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (EntityEvolver)((ComponentFactory)entry.getValue()).build(config)));
    }
}

