/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import org.axonframework.common.ConstructorUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.eventsourcing.AnnotationBasedEventSourcedComponent;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.annotation.CriteriaResolverDefinition;
import org.axonframework.eventsourcing.annotation.EventSourcedEntity;
import org.axonframework.eventsourcing.annotation.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.annotation.EventSourcedEntityFactoryDefinition;
import org.axonframework.eventsourcing.configuration.EventSourcedEntityBuilder;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.modelling.repository.Repository;

class AnnotatedEventSourcedEntityBuilder<I, E>
implements EventSourcedEntityBuilder<I, E> {
    private final Class<I> idType;
    private final Class<E> entityType;
    private final EventSourcedEntityFactoryDefinition<E, I> entityFactoryDefinition;
    private final CriteriaResolverDefinition criteriaResolverDefinition;
    private final AnnotationBasedEventSourcedComponent<E> entityEvolver;

    AnnotatedEventSourcedEntityBuilder(@Nonnull Class<I> idType, @Nonnull Class<E> entityType) {
        this.idType = Objects.requireNonNull(idType, "The id type cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type cannot be null.");
        Map annotationAttributes = (Map)AnnotationUtils.findAnnotationAttributes(entityType, EventSourcedEntity.class).orElseThrow(() -> new IllegalArgumentException("The given class is not an @EventSourcingEntity."));
        Class entityFactoryType = (Class)annotationAttributes.get("entityFactoryDefinition");
        this.entityFactoryDefinition = (EventSourcedEntityFactoryDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)entityFactoryType).get();
        Class criteriaResolverType = (Class)annotationAttributes.get("criteriaResolverDefinition");
        this.criteriaResolverDefinition = (CriteriaResolverDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)criteriaResolverType).get();
        this.entityEvolver = new AnnotationBasedEventSourcedComponent<E>(entityType);
    }

    public String entityName() {
        return this.entityType.getSimpleName() + "#" + this.idType.getSimpleName();
    }

    public ComponentFactory<Repository<I, E>> repository() {
        return c -> {
            CriteriaResolver<I> criteriaResolver = this.criteriaResolverDefinition.createEventCriteriaResolver(this.entityType, this.idType, c);
            EventSourcedEntityFactory<I, E> entityFactory = this.entityFactoryDefinition.createFactory(this.entityType, this.idType, c);
            return new EventSourcingRepository<I, E>(this.idType, this.entityType, (EventStore)c.getComponent(EventStore.class), entityFactory, criteriaResolver, this.entityEvolver);
        };
    }
}

