/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.EventSourcedComponent;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityEvolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventSourcedComponent<E>
implements EventSourcedComponent<E>,
DescribableComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<QualifiedName, EntityEvolver<E>> entityEvolvers;

    public SimpleEventSourcedComponent(@Nonnull Map<QualifiedName, EntityEvolver<E>> entityEvolvers) {
        this.entityEvolvers = new HashMap<QualifiedName, EntityEvolver<E>>(Objects.requireNonNull(entityEvolvers, "The entity evolvers cannot be null."));
    }

    public E evolve(@Nonnull E entity, @Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        QualifiedName eventName = Objects.requireNonNull(event, "The event must not be null.").type().qualifiedName();
        EntityEvolver<E> entityEvolver = this.entityEvolvers.get(eventName);
        if (entityEvolver == null) {
            logger.debug("Returning event sourced entity as is since we could not find an entity evolver for named event [{}].", (Object)eventName);
            return entity;
        }
        return (E)entityEvolver.evolve(Objects.requireNonNull(entity, "The entity must not be null."), event, Objects.requireNonNull(context, "The processing context must not be null."));
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.entityEvolvers.keySet());
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        Objects.requireNonNull(descriptor, "The component descriptor must not be null.").describeProperty("delegates", Collections.unmodifiableMap(this.entityEvolvers));
    }
}

