/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.annotation.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;

public class EventSourcingRepository<I, E>
implements Repository.LifecycleManagement<I, E> {
    private final Context.ResourceKey<Map<I, CompletableFuture<EventSourcedEntity<I, E>>>> managedEntitiesKey = Context.ResourceKey.withLabel((String)"managedEntities");
    private final Class<I> idType;
    private final Class<E> entityType;
    private final EventStore eventStore;
    private final CriteriaResolver<I> criteriaResolver;
    private final EntityEvolver<E> entityEvolver;
    private final EventSourcedEntityFactory<I, E> entityFactory;

    public EventSourcingRepository(@Nonnull Class<I> idType, @Nonnull Class<E> entityType, @Nonnull EventStore eventStore, @Nonnull EventSourcedEntityFactory<I, E> entityFactory, @Nonnull CriteriaResolver<I> criteriaResolver, @Nonnull EntityEvolver<E> entityEvolver) {
        this.idType = Objects.requireNonNull(idType, "The id type must not be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type must not be null.");
        this.eventStore = Objects.requireNonNull(eventStore, "The event store must not be null.");
        this.entityFactory = Objects.requireNonNull(entityFactory, "The entity factory must not be null.");
        this.criteriaResolver = Objects.requireNonNull(criteriaResolver, "The criteria resolver must not be null.");
        this.entityEvolver = Objects.requireNonNull(entityEvolver, "The entity evolver must not be null.");
    }

    public ManagedEntity<I, E> attach(@Nonnull ManagedEntity<I, E> entity, @Nonnull ProcessingContext processingContext) {
        Map managedEntities = (Map)processingContext.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return (ManagedEntity)managedEntities.computeIfAbsent(entity.identifier(), id -> {
            EventSourcedEntity sourcedEntity = EventSourcedEntity.mapToEventSourcedEntity(entity);
            this.updateActiveEntity(sourcedEntity, processingContext);
            return CompletableFuture.completedFuture(sourcedEntity);
        }).resultNow();
    }

    @Nonnull
    public Class<E> entityType() {
        return this.entityType;
    }

    @Nonnull
    public Class<I> idType() {
        return this.idType;
    }

    public CompletableFuture<ManagedEntity<I, E>> load(@Nonnull I identifier, @Nonnull ProcessingContext processingContext) {
        Map managedEntities = (Map)processingContext.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return managedEntities.computeIfAbsent(identifier, id -> this.eventStore.transaction(processingContext).source(SourcingCondition.conditionFor(this.criteriaResolver.resolve(id))).reduce(new EventSourcedEntity<Object, E>(identifier, this.entityFactory.createEntity(this.entityType(), identifier)), (entity, entry) -> {
            entity.evolve((EventMessage)entry.message(), this.entityEvolver, processingContext);
            return entity;
        }).whenComplete((entity, exception) -> {
            if (exception == null) {
                this.updateActiveEntity((EventSourcedEntity<I, E>)entity, processingContext);
            }
        })).thenApply(Function.identity());
    }

    public CompletableFuture<ManagedEntity<I, E>> loadOrCreate(@Nonnull I identifier, @Nonnull ProcessingContext processingContext) {
        return this.load(identifier, processingContext).thenApply(managedEntity -> {
            managedEntity.applyStateChange(entity -> entity != null ? entity : this.entityFactory.createEntity(this.entityType(), identifier));
            return managedEntity;
        });
    }

    public ManagedEntity<I, E> persist(@Nonnull I identifier, @Nonnull E entity, @Nonnull ProcessingContext processingContext) {
        Map managedEntities = (Map)processingContext.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return (ManagedEntity)managedEntities.computeIfAbsent(identifier, id -> {
            EventSourcedEntity<Object, Object> sourcedEntity = new EventSourcedEntity<Object, Object>(identifier, entity);
            this.updateActiveEntity(sourcedEntity, processingContext);
            return CompletableFuture.completedFuture(sourcedEntity);
        }).resultNow();
    }

    private void updateActiveEntity(EventSourcedEntity<I, E> entity, ProcessingContext processingContext) {
        this.eventStore.transaction(processingContext).onAppend(event -> entity.evolve((EventMessage<?>)event, this.entityEvolver, processingContext));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("idType", this.idType);
        descriptor.describeProperty("entityType", this.entityType);
        descriptor.describeProperty("eventStore", (Object)this.eventStore);
        descriptor.describeProperty("entityFactory", this.entityFactory);
        descriptor.describeProperty("criteriaResolver", this.criteriaResolver);
        descriptor.describeProperty("entityEvolver", this.entityEvolver);
    }

    private static class EventSourcedEntity<ID, M>
    implements ManagedEntity<ID, M> {
        private final ID identifier;
        private final AtomicReference<M> currentState;

        private EventSourcedEntity(ID identifier, M currentState) {
            this.identifier = identifier;
            this.currentState = new AtomicReference<M>(currentState);
        }

        private static <ID, T> EventSourcedEntity<ID, T> mapToEventSourcedEntity(ManagedEntity<ID, T> entity) {
            EventSourcedEntity<Object, Object> eventSourcedEntity;
            if (entity instanceof EventSourcedEntity) {
                EventSourcedEntity eventSourcedEntity2 = (EventSourcedEntity)entity;
                eventSourcedEntity = eventSourcedEntity2;
            } else {
                eventSourcedEntity = new EventSourcedEntity<Object, Object>(entity.identifier(), entity.entity());
            }
            return eventSourcedEntity;
        }

        public ID identifier() {
            return this.identifier;
        }

        public M entity() {
            return this.currentState.get();
        }

        public M applyStateChange(UnaryOperator<M> change) {
            return this.currentState.updateAndGet(change);
        }

        private M evolve(EventMessage<?> event, EntityEvolver<M> evolver, ProcessingContext processingContext) {
            return this.currentState.updateAndGet(current -> evolver.evolve(current, event, processingContext));
        }
    }
}

