/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.annotation.AnnotatedEventHandlingComponent;
import org.axonframework.eventsourcing.EventSourcedComponent;
import org.axonframework.eventsourcing.StateEvolvingException;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class AnnotationBasedEventSourcedComponent<E>
implements EventSourcedComponent<E> {
    private final Class<E> entityType;
    private final AnnotatedHandlerInspector<E> inspector;

    public AnnotationBasedEventSourcedComponent(@Nonnull Class<E> entityType) {
        this(entityType, AnnotatedHandlerInspector.inspectType(entityType, (ParameterResolverFactory)ClasspathParameterResolverFactory.forClass(entityType), (HandlerDefinition)ClasspathHandlerDefinition.forClass(entityType)));
    }

    public AnnotationBasedEventSourcedComponent(@Nonnull Class<E> entityType, @Nonnull AnnotatedHandlerInspector<E> inspector) {
        this.entityType = Objects.requireNonNull(entityType, "The entity type must not be null.");
        this.inspector = Objects.requireNonNull(inspector, "The Annotated Handler Inspector must not be null.");
    }

    public E evolve(@Nonnull E entity, @Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(entity, "The entity must not be null.");
        Objects.requireNonNull(event, "The event message must not be null.");
        try {
            AnnotatedEventHandlingComponent eventHandler = new AnnotatedEventHandlingComponent(entity, this.inspector);
            MessageStream.Entry eventHandlerResult = (MessageStream.Entry)eventHandler.handle(event, context).asCompletableFuture().join();
            return this.entityFromStreamResultOrUpdatedExisting(eventHandlerResult, entity);
        }
        catch (Exception e) {
            throw new StateEvolvingException("Failed to apply event [" + String.valueOf(event.type()) + "] in order to evolve [" + String.valueOf(entity.getClass()) + "] state", e);
        }
    }

    private E entityFromStreamResultOrUpdatedExisting(MessageStream.Entry<?> potentialEntityFromStream, E existing) {
        Object resultPayload;
        if (potentialEntityFromStream != null && (resultPayload = potentialEntityFromStream.message().getPayload()) != null && existing.getClass().isAssignableFrom(resultPayload.getClass())) {
            return (E)existing.getClass().cast(resultPayload);
        }
        return existing;
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return this.inspector.getHandlers(this.entityType).filter(Objects::nonNull).map(MessageHandlingMember::payloadType).map(QualifiedName::new).collect(Collectors.toSet());
    }
}

