/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import javax.annotation.Nonnull;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public abstract class AbstractSnapshotTrigger
implements SnapshotTrigger {
    private transient Snapshotter snapshotter;
    private Class<?> aggregateType;
    private boolean initialized;

    protected AbstractSnapshotTrigger(Snapshotter snapshotter, Class<?> aggregateType) {
        this.snapshotter = snapshotter;
        this.aggregateType = aggregateType;
        this.initialized = false;
    }

    @Override
    public void eventHandled(@Nonnull EventMessage<?> msg) {
        if (msg instanceof DomainEventMessage && this.exceedsThreshold()) {
            this.prepareSnapshotScheduling((DomainEventMessage)msg);
            this.reset();
        }
    }

    @Override
    public void initializationFinished() {
        this.initialized = true;
    }

    private void prepareSnapshotScheduling(DomainEventMessage<?> eventMessage) {
        if (CurrentUnitOfWork.isStarted()) {
            if (this.initialized) {
                CurrentUnitOfWork.get().onPrepareCommit(u -> this.scheduleSnapshot(eventMessage));
            } else {
                CurrentUnitOfWork.get().onCleanup(u -> this.scheduleSnapshot(eventMessage));
            }
        } else {
            this.scheduleSnapshot(eventMessage);
        }
    }

    private void scheduleSnapshot(DomainEventMessage<?> eventMessage) {
        this.snapshotter.scheduleSnapshot(this.aggregateType, eventMessage.getAggregateIdentifier());
    }

    public void setSnapshotter(Snapshotter snapshotter) {
        this.snapshotter = snapshotter;
    }

    protected abstract boolean exceedsThreshold();

    protected abstract void reset();
}

