/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.conflictresolution;

import java.util.List;
import java.util.function.Predicate;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;

public class Conflicts {
    public static <T extends EventMessage<?>> Predicate<List<T>> eventMatching(Predicate<? super T> messageFilter) {
        return events -> events.stream().anyMatch(messageFilter::test);
    }

    public static Predicate<List<DomainEventMessage<?>>> payloadMatching(Predicate<Object> payloadFilter) {
        return events -> events.stream().map(Message::getPayload).anyMatch(payloadFilter::test);
    }

    public static <T> Predicate<List<DomainEventMessage<?>>> payloadMatching(Class<T> payloadType, Predicate<? super T> payloadFilter) {
        return events -> events.stream().filter(event -> payloadType.isAssignableFrom(event.getPayloadType())).map(event -> event.getPayload()).anyMatch(payloadFilter::test);
    }

    public static <T> Predicate<List<DomainEventMessage<?>>> payloadTypeOf(Class<T> payloadType) {
        return Conflicts.eventMatching(event -> payloadType.isAssignableFrom(event.getPayloadType()));
    }

    private Conflicts() {
    }
}

