/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.snapshotting;

import java.util.Objects;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;

public class RevisionSnapshotFilter
implements SnapshotFilter {
    private final String type;
    private final String revision;

    public static Builder builder() {
        return new Builder();
    }

    protected RevisionSnapshotFilter(Builder builder) {
        builder.validate();
        this.type = builder.type;
        this.revision = builder.revision;
    }

    @Deprecated
    public RevisionSnapshotFilter(String allowedRevision) {
        this.revision = allowedRevision;
        this.type = "no-aggregate-type";
    }

    @Override
    public boolean test(DomainEventData<?> domainEventData) {
        String type = domainEventData.getType();
        String revision = domainEventData.getPayload().getType().getRevision();
        if (!Objects.equals(type, this.type)) {
            return true;
        }
        return Objects.equals(revision, this.revision);
    }

    public static class Builder {
        private String type;
        private String revision;

        public Builder type(Class<?> type) {
            return this.type(type.getName());
        }

        public Builder type(String type) {
            BuilderUtils.assertNonEmpty((String)type, (String)"The type may not be null or empty");
            this.type = type;
            return this;
        }

        public Builder revision(String revision) {
            BuilderUtils.assertNonEmpty((String)revision, (String)"The revision may not be null or empty");
            this.revision = revision;
            return this;
        }

        public RevisionSnapshotFilter build() {
            return new RevisionSnapshotFilter(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty((String)this.type, (String)"The type is a hard requirement and should be provided");
            BuilderUtils.assertNonEmpty((String)this.revision, (String)"The revision is a hard requirement and should be provided");
        }
    }
}

