/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;

public class SequenceEventStorageEngine
implements EventStorageEngine {
    private final EventStorageEngine historicStorage;
    private final EventStorageEngine activeStorage;

    public SequenceEventStorageEngine(EventStorageEngine historicStorage, EventStorageEngine activeStorage) {
        this.historicStorage = historicStorage;
        this.activeStorage = activeStorage;
    }

    @Override
    public void appendEvents(List<? extends EventMessage<?>> events) {
        this.activeStorage.appendEvents(events);
    }

    @Override
    public void storeSnapshot(DomainEventMessage<?> snapshot) {
        this.activeStorage.storeSnapshot(snapshot);
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        Spliterator historicSpliterator = this.historicStorage.readEvents(trackingToken, mayBlock).spliterator();
        ConcatenatingSpliterator merged = new ConcatenatingSpliterator(historicSpliterator, mayBlock, token -> this.activeStorage.readEvents((TrackingToken)token, mayBlock).spliterator());
        return StreamSupport.stream(merged, false);
    }

    @Override
    public DomainEventStream readEvents(String aggregateIdentifier, long firstSequenceNumber) {
        DomainEventStream historic = this.historicStorage.readEvents(aggregateIdentifier, firstSequenceNumber);
        return new ConcatenatingDomainEventStream(historic, aggregateIdentifier, (id, seq) -> this.activeStorage.readEvents(aggregateIdentifier, (long)seq));
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(String aggregateIdentifier) {
        Optional<DomainEventMessage<?>> optionalDomainEventMessage = this.activeStorage.readSnapshot(aggregateIdentifier);
        return optionalDomainEventMessage.isPresent() ? optionalDomainEventMessage : this.historicStorage.readSnapshot(aggregateIdentifier);
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        Optional<Long> result = this.activeStorage.lastSequenceNumberFor(aggregateIdentifier);
        if (result.isPresent()) {
            return result;
        }
        return this.historicStorage.lastSequenceNumberFor(aggregateIdentifier);
    }

    @Override
    public TrackingToken createTailToken() {
        return this.historicStorage.createTailToken();
    }

    @Override
    public TrackingToken createHeadToken() {
        return this.activeStorage.createHeadToken();
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        TrackingToken tokenFromActiveStorage = this.activeStorage.createTokenAt(dateTime);
        if (tokenFromActiveStorage == null) {
            return this.historicStorage.createTokenAt(dateTime);
        }
        return tokenFromActiveStorage;
    }

    private class ConcatenatingDomainEventStream
    implements DomainEventStream {
        private final DomainEventStream historic;
        private final String aggregateIdentifier;
        private DomainEventStream actual;
        private final BiFunction<String, Long, DomainEventStream> domainEventStream;

        public ConcatenatingDomainEventStream(DomainEventStream historic, String aggregateIdentifier, BiFunction<String, Long, DomainEventStream> domainEventStream) {
            this.historic = historic;
            this.aggregateIdentifier = aggregateIdentifier;
            this.domainEventStream = domainEventStream;
        }

        @Override
        public boolean hasNext() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.hasNext();
            }
            return this.actual.hasNext();
        }

        private void initActiveIfRequired() {
            if (this.actual == null && !this.historic.hasNext()) {
                this.actual = this.domainEventStream.apply(this.aggregateIdentifier, this.nextSequenceNumber());
            }
        }

        private long nextSequenceNumber() {
            Long lastSequenceNumber = this.historic.getLastSequenceNumber();
            return lastSequenceNumber == null ? 0L : lastSequenceNumber + 1L;
        }

        @Override
        public DomainEventMessage<?> next() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.next();
            }
            return this.actual.next();
        }

        @Override
        public DomainEventMessage<?> peek() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.peek();
            }
            return this.actual.peek();
        }

        @Override
        public Long getLastSequenceNumber() {
            this.initActiveIfRequired();
            if (this.actual == null) {
                return this.historic.getLastSequenceNumber();
            }
            Long actualLastSequenceNumber = this.actual.getLastSequenceNumber();
            return actualLastSequenceNumber != null ? actualLastSequenceNumber : this.historic.getLastSequenceNumber();
        }
    }

    private class ConcatenatingSpliterator
    extends Spliterators.AbstractSpliterator<TrackedEventMessage<?>> {
        private final Spliterator<? extends TrackedEventMessage<?>> historicSpliterator;
        private final boolean mayBlock;
        private Spliterator<? extends TrackedEventMessage<?>> active;
        private TrackingToken lastToken;
        private final Function<TrackingToken, Spliterator<? extends TrackedEventMessage<?>>> nextProvider;

        public ConcatenatingSpliterator(Spliterator<? extends TrackedEventMessage<?>> historicSpliterator, boolean mayBlock, Function<TrackingToken, Spliterator<? extends TrackedEventMessage<?>>> nextProvider) {
            super(Long.MAX_VALUE, 16);
            this.historicSpliterator = historicSpliterator;
            this.mayBlock = mayBlock;
            this.nextProvider = nextProvider;
        }

        @Override
        public boolean tryAdvance(Consumer<? super TrackedEventMessage<?>> action) {
            if (this.active == null && this.historicSpliterator.tryAdvance((? super T message) -> {
                this.lastToken = message.trackingToken();
                action.accept((TrackedEventMessage<?>)message);
            })) {
                return true;
            }
            if (this.active == null) {
                this.active = this.nextProvider.apply(this.lastToken);
            }
            return this.active.tryAdvance(action);
        }
    }
}

