/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;

public class ConcatenatingDomainEventStream
implements DomainEventStream {
    private final LinkedList<DomainEventStream> streams;
    private Long lastSequenceNumber;

    public ConcatenatingDomainEventStream(DomainEventStream ... streams) {
        this(Arrays.asList(streams));
    }

    public ConcatenatingDomainEventStream(Collection<DomainEventStream> streams) {
        this.streams = new LinkedList<DomainEventStream>(streams);
    }

    @Override
    public DomainEventMessage<?> peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.streams.peekFirst().peek();
    }

    @Override
    public boolean hasNext() {
        if (!this.streams.isEmpty() && this.streams.peekFirst().hasNext()) {
            return true;
        }
        while (!this.streams.isEmpty() && !this.streams.peekFirst().hasNext()) {
            this.streams.pollFirst();
        }
        if (this.streams.isEmpty()) {
            return false;
        }
        DomainEventMessage<?> peeked = this.streams.peekFirst().peek();
        while (this.lastSequenceNumber != null && peeked.getSequenceNumber() <= this.lastSequenceNumber) {
            while (!this.streams.peekFirst().hasNext()) {
                this.streams.pollFirst();
                if (!this.streams.isEmpty()) continue;
                return false;
            }
            this.streams.peekFirst().next();
            if (!this.streams.peekFirst().hasNext()) continue;
            peeked = this.streams.peekFirst().peek();
        }
        return !this.streams.isEmpty() && this.streams.peekFirst().hasNext();
    }

    @Override
    public DomainEventMessage<?> next() {
        if (!this.hasNext()) {
            return null;
        }
        DomainEventMessage<?> next = this.streams.peekFirst().next();
        this.lastSequenceNumber = next.getSequenceNumber();
        return next;
    }

    @Override
    public Long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }
}

